/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.shared.client.QBrowseReply;
import org.objectweb.joram.shared.client.QBrowseRequest;
import org.objectweb.joram.shared.excepts.SelectorException;
import org.objectweb.joram.shared.selectors.ClientSelector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class QueueBrowser
implements javax.jms.QueueBrowser {
    private Session sess;
    private Queue queue;
    private String selector;
    private boolean closed = false;
    private static Logger logger = Debug.getLogger(QueueBrowser.class.getName());

    QueueBrowser(Session sess, Queue queue, String selector) throws JMSException {
        if (queue == null) {
            throw new InvalidDestinationException("Invalid queue: " + queue);
        }
        queue.check();
        try {
            ClientSelector.checks(selector);
        }
        catch (SelectorException sE) {
            throw new InvalidSelectorException("Invalid selector syntax: " + sE);
        }
        this.sess = sess;
        this.queue = queue;
        this.selector = selector;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public String toString() {
        return "QueueBrowser:" + this.sess.getId();
    }

    public synchronized javax.jms.Queue getQueue() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.queue;
    }

    public synchronized String getMessageSelector() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.selector;
    }

    public synchronized Enumeration getEnumeration() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": requests an enumeration."));
        }
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        QBrowseRequest browReq = new QBrowseRequest(this.queue.getName(), this.selector);
        QBrowseReply reply = (QBrowseReply)this.sess.syncRequest(browReq);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": received an enumeration."));
        }
        return new QueueEnumeration(reply.getMessages());
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.sess.closeBrowser(this);
        this.closed = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " closed."));
        }
    }

    private class QueueEnumeration
    implements Enumeration {
        private Vector messages;

        private QueueEnumeration(Vector messages) {
            this.messages = messages;
        }

        public boolean hasMoreElements() {
            if (this.messages == null) {
                return false;
            }
            return !this.messages.isEmpty();
        }

        public Object nextElement() {
            if (this.messages == null || this.messages.isEmpty()) {
                throw new NoSuchElementException();
            }
            Message jmsMsg = null;
            org.objectweb.joram.shared.messages.Message msg = null;
            try {
                msg = (org.objectweb.joram.shared.messages.Message)this.messages.remove(0);
                jmsMsg = Message.wrapMomMessage(null, msg);
            }
            catch (JMSException exc) {
                logger.log(BasicLevel.ERROR, (Object)(this + ", bad message: " + msg), (Throwable)exc);
            }
            return jmsMsg;
        }
    }
}

