/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.local;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.joram.client.jms.local.LocalConnectionsMBean;
import org.objectweb.joram.client.jms.local.LocalRequestChannel;
import org.objectweb.joram.mom.proxies.ConnectionManager;

public class LocalConnections
implements LocalConnectionsMBean {
    private static final String MBEAN_NAME = "type=Connection,mode=local";
    private static LocalConnections currentInstance;
    private List connections = new ArrayList();
    private boolean activated = true;
    private int failedLoginCount;
    private int initiatedConnectionCount;

    public void activate() {
        this.activated = true;
    }

    public void closeAllConnections() {
        LocalRequestChannel[] array = this.connections.toArray(new LocalRequestChannel[this.connections.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i].close();
        }
    }

    public void deactivate() {
        this.activated = false;
    }

    public int getRunningConnectionsCount() {
        return this.connections.size();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void addLocalConnection(LocalRequestChannel localRequestChannel) {
        this.connections.add(localRequestChannel);
    }

    public void removeLocalConnection(LocalRequestChannel localRequestChannel) {
        this.connections.remove(localRequestChannel);
    }

    public static synchronized LocalConnections getCurrentInstance() {
        if (currentInstance == null) {
            currentInstance = new LocalConnections();
            ConnectionManager.getCurrentInstance().addManager(currentInstance);
        }
        return currentInstance;
    }

    public String getMBeanName() {
        return MBEAN_NAME;
    }

    public int getFailedLoginCount() {
        return this.failedLoginCount;
    }

    public synchronized void increaseFailedLoginCount() {
        ++this.failedLoginCount;
    }

    public int getInitiatedConnectionCount() {
        return this.initiatedConnectionCount;
    }

    public synchronized void increaseInitiatedConnectionCount() {
        ++this.initiatedConnectionCount;
    }
}

