/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.UnknownNotificationException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.objectweb.joram.mom.dest.LoadingFactor;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.AckJoinQueueCluster;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.JoinQueueCluster;
import org.objectweb.joram.mom.notifications.LBCycleLife;
import org.objectweb.joram.mom.notifications.LBMessageGive;
import org.objectweb.joram.mom.notifications.LBMessageHope;
import org.objectweb.joram.mom.notifications.LeaveQueueCluster;
import org.objectweb.joram.mom.notifications.QueueClusterNot;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SpecialAdminRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AddQueueCluster;
import org.objectweb.joram.shared.admin.ListClusterQueue;
import org.objectweb.joram.shared.admin.RemoveQueueCluster;
import org.objectweb.joram.shared.admin.SpecialAdmin;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class ClusterQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    protected Hashtable clusters;
    protected LoadingFactor loadingFactor;
    private LinkedHashMap timeTable;
    private Hashtable visitTable;
    private long clusterDeliveryCount;
    private long waitAfterClusterReq = -1L;
    private long timeThreshold = -1L;

    public ClusterQueueImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        int producThreshold = -1;
        int consumThreshold = -1;
        boolean autoEvalThreshold = false;
        if (prop != null) {
            try {
                this.waitAfterClusterReq = Long.valueOf(prop.getProperty("waitAfterClusterReq"));
            }
            catch (NumberFormatException exc) {
                this.waitAfterClusterReq = 60000L;
            }
            try {
                producThreshold = Integer.valueOf(prop.getProperty("producThreshold"));
            }
            catch (NumberFormatException exc) {
                producThreshold = 10000;
            }
            try {
                consumThreshold = Integer.valueOf(prop.getProperty("consumThreshold"));
            }
            catch (NumberFormatException exc) {
                consumThreshold = 10000;
            }
            autoEvalThreshold = Boolean.valueOf(prop.getProperty("autoEvalThreshold"));
            try {
                this.timeThreshold = Long.valueOf(prop.getProperty("timeThreshold"));
            }
            catch (NumberFormatException exc) {
                this.timeThreshold = this.getPeriod();
            }
        }
        this.loadingFactor = new LoadingFactor(this, producThreshold, consumThreshold, autoEvalThreshold, this.waitAfterClusterReq);
        this.timeTable = new LinkedHashMap();
        this.visitTable = new Hashtable();
        this.clusterDeliveryCount = 0L;
    }

    public void initialize(boolean firstTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("initialize(" + firstTime + ')'));
        }
        super.initialize(firstTime);
        if (firstTime) {
            this.clusters = new Hashtable();
            this.clusters.put(this.getId(), new Float(1.0f));
        }
    }

    public String toString() {
        return "ClusterQueueImpl:" + this.getId().toString();
    }

    public Object specialAdminProcess(SpecialAdminRequest not) throws RequestException {
        Object ret = null;
        try {
            SpecialAdmin req = not.getRequest();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " specialAdminProcess : " + req));
            }
            if (req instanceof AddQueueCluster) {
                this.addQueueCluster(((AddQueueCluster)req).joiningQueue, this.loadingFactor.getRateOfFlow());
            } else if (req instanceof RemoveQueueCluster) {
                this.broadcastLeave(((RemoveQueueCluster)req).removeQueue);
                this.removeQueueCluster(((RemoveQueueCluster)req).removeQueue);
            } else if (req instanceof ListClusterQueue) {
                ret = this.doList((ListClusterQueue)req);
            }
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)("--- " + this + " specialAdminProcess"), (Throwable)exc);
            }
            throw new RequestException(exc.getMessage());
        }
        return ret;
    }

    protected Object doList(ListClusterQueue req) {
        ArrayList<String> vect = new ArrayList<String>();
        Enumeration e = this.clusters.keys();
        while (e.hasMoreElements()) {
            vect.add(e.nextElement().toString());
        }
        return vect;
    }

    protected void addQueueCluster(String joiningQueue, float rateOfFlow) {
        AgentId id = AgentId.fromString(joiningQueue);
        if (this.clusters.containsKey(id)) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.addQueueCluster in " + this.getId() + "\njoiningQueue=" + joiningQueue + "\nclusters=" + this.clusters));
        }
        this.forward(id, new JoinQueueCluster(this.loadingFactor.getRateOfFlow(), this.clusters, this.clients, this.freeReading, this.freeWriting));
    }

    protected void broadcastLeave(String removeQueue) {
        this.sendToCluster(new LeaveQueueCluster(removeQueue));
    }

    public void removeQueueCluster(String removeQueue) {
        AgentId id = AgentId.fromString(removeQueue);
        if (this.getId().equals(id)) {
            this.clusters.clear();
        } else {
            this.clusters.remove(id);
        }
        Enumeration e = this.visitTable.elements();
        while (e.hasMoreElements()) {
            List visit = (List)e.nextElement();
            if (!visit.contains(id)) continue;
            visit.remove(id);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.removeQueueCluster in " + this.getId() + "\nremoveQueue=" + removeQueue + "\nclusters=" + this.clusters));
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " " + not));
        }
        this.receiving = true;
        long date = System.currentTimeMillis();
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
            ++this.arrivalsCounter;
            msg.order = msg.order;
            this.storeMsgIdInTimeTable(msg.getIdentifier(), new Long(date));
        }
        return not;
    }

    public void postProcess(ClientMessages not) {
        if (this.getPendingMessageCount() > this.loadingFactor.producThreshold) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        } else {
            this.loadingFactor.evalRateOfFlow(this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
        this.receiving = false;
    }

    public void wakeUpNot(WakeUpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.wakeUpNot(" + not + ")"));
        }
        super.wakeUpNot(not);
        if (this.clusters.size() > 1) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
        ArrayList<String> toGive = new ArrayList<String>();
        long oldTime = System.currentTimeMillis() - this.timeThreshold;
        Set keySet = this.timeTable.keySet();
        for (String msgId : keySet) {
            if ((Long)this.timeTable.get(msgId) >= oldTime) continue;
            toGive.add(msgId);
            this.storeMsgIdInVisitTable(msgId, this.getId());
        }
        if (toGive.isEmpty()) {
            return;
        }
        Hashtable<AgentId, LBCycleLife> table = new Hashtable<AgentId, LBCycleLife>();
        for (int i = 0; i < toGive.size(); ++i) {
            String msgId = (String)toGive.get(i);
            List visit = (List)this.visitTable.get(msgId);
            boolean transmitted = false;
            Enumeration e = this.clusters.keys();
            while (e.hasMoreElements()) {
                org.objectweb.joram.mom.messages.Message message;
                AgentId id = (AgentId)e.nextElement();
                if (visit.contains(id) || (message = this.getQueueMessage(msgId, true)) == null) continue;
                LBCycleLife cycle = (LBCycleLife)table.get(id);
                if (cycle == null) {
                    cycle = new LBCycleLife(this.loadingFactor.getRateOfFlow());
                    cycle.setClientMessages(new ClientMessages());
                }
                ClientMessages cm = cycle.getClientMessages();
                cm.addMessage(message.getFullMessage());
                cycle.putInVisitTable(msgId, visit);
                table.put(id, cycle);
                transmitted = true;
                break;
            }
            if (transmitted) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" All queues already visited. Re-initialize visitTable.");
            }
            ((List)this.visitTable.get(msgId)).clear();
        }
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            AgentId id = (AgentId)e.nextElement();
            this.forward(id, (LBCycleLife)table.get(id));
        }
    }

    public void lBCycleLife(AgentId from, LBCycleLife not) {
        ClientMessages cm;
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        Hashtable vT = not.getVisitTable();
        Enumeration e = vT.keys();
        while (e.hasMoreElements()) {
            String msgId = (String)e.nextElement();
            this.visitTable.put(msgId, vT.get(msgId));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.lBCycleLife(" + not + ")" + "\nvisitTable=" + this.clusters));
        }
        if ((cm = not.getClientMessages()) != null) {
            this.doClientMessages(from, cm);
        }
    }

    public void joinQueueCluster(JoinQueueCluster not) {
        Enumeration e = not.clusters.keys();
        while (e.hasMoreElements()) {
            AgentId id = (AgentId)e.nextElement();
            if (this.clusters.containsKey(id)) continue;
            this.clusters.put(id, not.clusters.get(id));
        }
        e = not.clients.keys();
        while (e.hasMoreElements()) {
            AgentId user = (AgentId)e.nextElement();
            if (this.clients.containsKey(user)) {
                Integer right = (Integer)not.clients.get(user);
                if (right.compareTo((Integer)this.clients.get(user)) <= 0) continue;
                this.clients.put(user, right);
                continue;
            }
            this.clients.put(user, not.clients.get(user));
        }
        this.freeReading |= not.freeReading;
        this.freeWriting |= not.freeWriting;
        this.sendToCluster(new AckJoinQueueCluster(this.loadingFactor.getRateOfFlow(), this.clusters, this.clients, this.freeReading, this.freeWriting));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.joinQueueCluster(" + not + ")" + "\nclusters=" + this.clusters + "\nclients=" + this.clients));
        }
    }

    public void ackJoinQueueCluster(AckJoinQueueCluster not) {
        boolean update = false;
        Enumeration e = not.clusters.keys();
        while (e.hasMoreElements()) {
            AgentId id = (AgentId)e.nextElement();
            if (this.clusters.containsKey(id)) continue;
            this.clusters.put(id, not.clusters.get(id));
            update = true;
        }
        e = not.clients.keys();
        while (e.hasMoreElements()) {
            AgentId user = (AgentId)e.nextElement();
            if (this.clients.containsKey(user)) {
                Integer right = (Integer)not.clients.get(user);
                if (right.compareTo((Integer)this.clients.get(user)) <= 0) continue;
                this.clients.put(user, right);
                continue;
            }
            this.clients.put(user, not.clients.get(user));
        }
        this.freeReading |= not.freeReading;
        this.freeWriting |= not.freeWriting;
        if (update) {
            this.sendToCluster(new AckJoinQueueCluster(this.loadingFactor.getRateOfFlow(), this.clusters, this.clients, this.freeReading, this.freeWriting));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.ackJoinQueueCluster(" + not + ")" + "\nclusters=" + this.clusters + "\nclients=" + this.clients));
        }
    }

    public void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        super.receiveRequest(from, not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.receiveRequest(" + not + ")"));
        }
        if (this.getWaitingRequestCount() > this.loadingFactor.consumThreshold) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
    }

    public void lBMessageGive(AgentId from, LBMessageGive not) throws UnknownNotificationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.lBMessageGive(" + from + "," + not + ")"));
        }
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        ClientMessages cm = not.getClientMessages();
        if (cm != null) {
            this.doClientMessages(from, cm);
        }
    }

    public void lBMessageHope(AgentId from, LBMessageHope not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.lBMessageHope(" + from + "," + not + ")"));
        }
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        int hope = not.getNbMsg();
        long current = System.currentTimeMillis();
        DMQManager dmqManager = this.cleanPendingMessage(current);
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (this.loadingFactor.getRateOfFlow() < 1.0f) {
            int possibleGive = this.getPendingMessageCount() - this.getWaitingRequestCount();
            LBMessageGive msgGive = new LBMessageGive(this.waitAfterClusterReq, this.loadingFactor.getRateOfFlow());
            ClientMessages cm = null;
            cm = possibleGive > hope ? this.getClientMessages(hope, null, true) : this.getClientMessages(possibleGive, null, true);
            msgGive.setClientMessages(cm);
            msgGive.setRateOfFlow(this.loadingFactor.evalRateOfFlow(this.getPendingMessageCount(), this.getWaitingRequestCount()));
            this.forward(from, msgGive);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.lBMessageHope LBMessageHope : nbMsgSend = " + cm.getMessages().size()));
            }
        }
    }

    protected ClientMessages getClientMessages(int nb, String selector, boolean remove) {
        ClientMessages cm = super.getClientMessages(nb, selector, remove);
        if (cm != null) {
            Enumeration e = cm.getMessages().elements();
            while (e.hasMoreElements()) {
                Message message = (Message)e.nextElement();
                this.monitoringMsgSendToCluster(message.id);
            }
        }
        return cm;
    }

    protected org.objectweb.joram.mom.messages.Message getQueueMessage(String msgId, boolean remove) {
        org.objectweb.joram.mom.messages.Message msg = super.getQueueMessage(msgId, remove);
        if (msg != null) {
            this.monitoringMsgSendToCluster(msg.getIdentifier());
        }
        return msg;
    }

    protected void sendToCluster(QueueClusterNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueueImpl.sendToCluster(" + not + ")"));
        }
        if (this.clusters.size() < 2) {
            return;
        }
        Enumeration e = this.clusters.keys();
        while (e.hasMoreElements()) {
            AgentId id = (AgentId)e.nextElement();
            if (id.equals(this.getId())) continue;
            this.forward(id, not);
        }
    }

    public long getClusterDeliveryCount() {
        return this.clusterDeliveryCount;
    }

    private void storeMsgIdInTimeTable(String msgId, Long date) {
        try {
            this.timeTable.put(msgId, date);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void storeMsgIdInVisitTable(String msgId, AgentId destId) {
        ArrayList<AgentId> alreadyVisit = (ArrayList<AgentId>)this.visitTable.get(msgId);
        if (alreadyVisit == null) {
            alreadyVisit = new ArrayList<AgentId>();
        }
        alreadyVisit.add(destId);
        this.visitTable.put(msgId, alreadyVisit);
    }

    protected void messageDelivered(String msgId) {
        this.timeTable.remove(msgId);
        this.visitTable.remove(msgId);
    }

    protected void monitoringMsgSendToCluster(String msgId) {
        this.timeTable.remove(msgId);
        this.visitTable.remove(msgId);
        ++this.clusterDeliveryCount;
    }

    public void setWaitAfterClusterReq(long waitAfterClusterReq) {
        this.waitAfterClusterReq = waitAfterClusterReq;
        this.loadingFactor.validityPeriod = waitAfterClusterReq;
    }

    public void setProducThreshold(int producThreshold) {
        this.loadingFactor.producThreshold = producThreshold;
    }

    public void setConsumThreshold(int consumThreshold) {
        this.loadingFactor.consumThreshold = consumThreshold;
    }

    public void setAutoEvalThreshold(boolean autoEvalThreshold) {
        this.loadingFactor.autoEvalThreshold = autoEvalThreshold;
    }
}

