/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.objectweb.joram.mom.dest.ClusterAck;
import org.objectweb.joram.mom.dest.ClusterNot;
import org.objectweb.joram.mom.dest.ClusterTest;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.FatherAck;
import org.objectweb.joram.mom.dest.FatherTest;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.TopicForwardNot;
import org.objectweb.joram.mom.dest.TopicImplMBean;
import org.objectweb.joram.mom.dest.UnclusterNot;
import org.objectweb.joram.mom.notifications.AdminReply;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ClusterRequest;
import org.objectweb.joram.mom.notifications.DestinationAdminRequestNot;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.Monit_GetCluster;
import org.objectweb.joram.mom.notifications.Monit_GetClusterRep;
import org.objectweb.joram.mom.notifications.Monit_GetFather;
import org.objectweb.joram.mom.notifications.Monit_GetFatherRep;
import org.objectweb.joram.mom.notifications.Monit_GetNumberRep;
import org.objectweb.joram.mom.notifications.Monit_GetSubscriptions;
import org.objectweb.joram.mom.notifications.SetFatherRequest;
import org.objectweb.joram.mom.notifications.SetRightRequest;
import org.objectweb.joram.mom.notifications.SubscribeReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.UnclusterRequest;
import org.objectweb.joram.mom.notifications.UnsetFatherRequest;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.GetSubscriberIds;
import org.objectweb.joram.shared.admin.GetSubscriberIdsRep;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;

public class TopicImpl
extends DestinationImpl
implements TopicImplMBean {
    private static final long serialVersionUID = 1L;
    protected AgentId fatherId = null;
    protected Set friends = null;
    protected Vector subscribers = new Vector();
    protected Hashtable selectors = new Hashtable();
    protected transient boolean alreadySentLocally;

    public TopicImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
    }

    public void initialize(boolean firstTime) {
    }

    public String toString() {
        return "TopicImpl:" + this.getId().toString();
    }

    public void wakeUpNot(WakeUpNot not) {
    }

    public void clusterRequest(AgentId from, ClusterRequest req) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        String info = null;
        if (this.fatherId != null) {
            info = this.strbuf.append("Request [").append(req.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: topic part of a hierarchy").toString();
            this.strbuf.setLength(0);
            this.forward(from, new AdminReply(req, false, info));
            return;
        }
        AgentId newFriendId = req.getTopicId();
        if (this.friends == null) {
            this.setSave();
            this.friends = new HashSet();
        }
        if (this.getId().equals(newFriendId)) {
            info = this.strbuf.append("Request [").append(req.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: joining topic already").append(" part of cluster").toString();
            this.strbuf.setLength(0);
            this.forward(from, new AdminReply(req, false, info));
            return;
        }
        ClusterTest not = new ClusterTest(req, from, this.friends);
        this.forward(newFriendId, not);
    }

    public void clusterTest(AgentId from, ClusterTest not) {
        String info = null;
        if (this.friends != null && !this.friends.isEmpty()) {
            if (this.friends.contains(from)) {
                info = this.strbuf.append("Topic [").append(this.getId()).append("] already joined cluster of topic [").append(from).append(']').toString();
                this.strbuf.setLength(0);
                this.friends.add(from);
                this.friends.addAll(not.friends);
                this.friends.remove(this.getId());
                this.forward(from, new ClusterAck(not, true, info));
            } else {
                info = this.strbuf.append("Topic [").append(this.getId()).append("] can't join cluster of topic [").append(from).append("] as it is already part of a cluster").toString();
                this.strbuf.setLength(0);
                this.forward(from, new ClusterAck(not, false, info));
            }
        } else if (this.fatherId != null) {
            info = this.strbuf.append("Topic [").append(this.getId()).append("] can't join cluster of topic [").append(from).append("] as it is already part of a hierarchy").toString();
            this.strbuf.setLength(0);
            this.forward(from, new ClusterAck(not, false, info));
        } else {
            this.setSave();
            this.friends = new HashSet();
            this.friends.add(from);
            this.friends.addAll(not.friends);
            this.friends.remove(this.getId());
            info = this.strbuf.append("Topic [").append(this.getId()).append("] ok for joining cluster of topic [").append(from).append(']').toString();
            this.strbuf.setLength(0);
            this.forward(from, new ClusterAck(not, true, info));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Topic " + this.getId().toString() + " joins cluster of topic " + from.toString()));
            }
        }
    }

    public void clusterAck(AgentId from, ClusterAck ack) {
        if (!ack.ok) {
            this.forward(ack.requester, new AdminReply(ack.request, false, ack.info));
            return;
        }
        ClusterNot newFriendNot = new ClusterNot(from);
        Iterator iterator = this.friends.iterator();
        while (iterator.hasNext()) {
            this.forward((AgentId)iterator.next(), newFriendNot);
        }
        this.setSave();
        this.friends.add(from);
        String info = this.strbuf.append("Request [").append(ack.request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [true]: topic [").append(from).append("] joined cluster").toString();
        this.strbuf.setLength(0);
        this.forward(ack.requester, new AdminReply(ack.request, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void clusterNot(AgentId from, ClusterNot not) {
        if (!not.topicId.equals(this.getId())) {
            this.setSave();
            this.friends.add(not.topicId);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Topic " + not.topicId.toString() + " set as a fellow."));
            }
        }
    }

    public void unclusterRequest(AgentId from, UnclusterRequest request) throws MomException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        if (this.friends == null || this.friends.isEmpty()) {
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: topic not part of a cluster").toString();
            this.strbuf.setLength(0);
            this.forward(from, new AdminReply(request, false, info));
            return;
        }
        UnclusterNot not = new UnclusterNot();
        Iterator iterator = this.friends.iterator();
        while (iterator.hasNext()) {
            this.forward((AgentId)iterator.next(), not);
        }
        this.friends = null;
        this.setSave();
        String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [true]: topic left the cluster").toString();
        this.strbuf.setLength(0);
        this.forward(from, new AdminReply(request, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void unclusterNot(AgentId from, UnclusterNot not) {
        this.setSave();
        this.friends.remove(from);
        if (this.friends.isEmpty()) {
            this.friends = null;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Topic " + from.toString() + " removed from" + " cluster."));
        }
    }

    public void setFatherRequest(AgentId from, SetFatherRequest request) throws MomException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        if (this.fatherId != null && !this.fatherId.equals(request.getFatherId())) {
            this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: topic already part of a hierarchy");
            this.forward(from, new AdminReply(request, false, this.strbuf.toString()));
            this.strbuf.setLength(0);
            return;
        }
        if (this.friends != null) {
            this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: topic already part of a cluster");
            this.forward(from, new AdminReply(request, false, this.strbuf.toString()));
            this.strbuf.setLength(0);
            return;
        }
        this.forward(request.getFatherId(), new FatherTest(request, from));
    }

    public void fatherTest(AgentId from, FatherTest not) {
        if (this.friends != null && !this.friends.isEmpty()) {
            this.strbuf.append("Topic [").append(this.getId()).append("] can't accept topic [").append(from).append("] as a son as it is part of a cluster");
            this.forward(from, new FatherAck(not, false, this.strbuf.toString()));
            this.strbuf.setLength(0);
        } else {
            this.strbuf.append("Topic [").append(this.getId()).append("] accepts topic [").append(from).append("] as a son");
            this.forward(from, new FatherAck(not, true, this.strbuf.toString()));
            this.strbuf.setLength(0);
        }
    }

    public void fatherAck(AgentId from, FatherAck not) {
        if (!not.ok) {
            this.forward(not.requester, new AdminReply(not.request, false, not.info));
            return;
        }
        this.setSave();
        this.fatherId = from;
        String info = this.strbuf.append("Request [").append(not.request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [true]: topic [").append(from).append("] set as father").toString();
        this.strbuf.setLength(0);
        this.forward(not.requester, new AdminReply(not.request, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void unsetFatherRequest(AgentId from, UnsetFatherRequest request) throws MomException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        String info = null;
        if (this.fatherId == null) {
            info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [false]: topic is not a son").toString();
            this.strbuf.setLength(0);
            this.forward(from, new AdminReply(request, false, info));
            return;
        }
        this.setSave();
        this.fatherId = null;
        info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to Topic [").append(this.getId()).append("], successful [true]: father unset").toString();
        this.strbuf.setLength(0);
        this.forward(from, new AdminReply(request, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void monitGetSubscriptions(AgentId from, Monit_GetSubscriptions not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        this.forward(from, new Monit_GetNumberRep(not, this.subscribers.size()));
    }

    public void monitGetFather(AgentId from, Monit_GetFather not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        String id = null;
        if (this.fatherId != null) {
            id = this.fatherId.toString();
        }
        this.forward(from, new Monit_GetFatherRep(not, id));
    }

    public void monitGetCluster(AgentId from, Monit_GetCluster not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        Vector<String> cluster = null;
        if (this.friends != null) {
            cluster = new Vector<String>();
            Iterator iterator = this.friends.iterator();
            while (iterator.hasNext()) {
                cluster.add(iterator.next().toString());
            }
            cluster.add(this.getId().toString());
        }
        this.forward(from, new Monit_GetClusterRep(not, cluster));
    }

    public void preSubscribe(SubscribeRequest not) {
    }

    public void postSubscribe(SubscribeRequest not) {
    }

    public void subscribeRequest(AgentId from, SubscribeRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        this.preSubscribe(not);
        if (!this.subscribers.contains(from)) {
            this.setSave();
            this.subscribers.add(from);
        }
        this.setSave();
        if (not.getSelector() != null && !not.getSelector().equals("")) {
            this.selectors.put(from, not.getSelector());
        } else {
            this.selectors.remove(from);
        }
        if (!not.isAsyncSub()) {
            this.forward(from, new SubscribeReply(not));
        }
        this.postSubscribe(not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " set as a subscriber with selector " + not.getSelector()));
        }
    }

    public void preUnsubscribe(UnsubscribeRequest not) {
    }

    public void postUnsubscribe(UnsubscribeRequest not) {
    }

    public void unsubscribeRequest(AgentId from, UnsubscribeRequest not) {
        this.preUnsubscribe(not);
        this.setSave();
        this.subscribers.remove(from);
        this.selectors.remove(from);
        this.postUnsubscribe(not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " removed from the subscribers."));
        }
    }

    public void topicForwardNot(AgentId from, TopicForwardNot not) {
        if (not.toFather && this.fatherId != null) {
            this.forward(this.fatherId, not);
            this.alreadySentLocally = this.fatherId.getTo() == AgentServer.getServerId();
        }
        this.processMessages(not.messages);
    }

    public void destinationAdminRequestNot(AgentId from, DestinationAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetSubscriberIds) {
            this.getSubscriberIds((GetSubscriberIds)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }

    private void getSubscriberIds(GetSubscriberIds request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        GetSubscriberIdsRep reply = new GetSubscriberIdsRep(this.getSubscriberIds());
        this.replyToTopic(reply, replyTo, requestMsgId, replyMsgId);
    }

    public String[] getSubscriberIds() {
        String[] res = new String[this.subscribers.size()];
        for (int i = 0; i < res.length; ++i) {
            AgentId aid = (AgentId)this.subscribers.elementAt(i);
            res[i] = aid.toString();
        }
        return res;
    }

    protected void doRightRequest(SetRightRequest not) {
        if (not.getRight() != -READ) {
            return;
        }
        SetRightRequest rightRequest = this.preProcess(not);
        if (rightRequest != null) {
            AgentId user = rightRequest.getClient();
            AccessException exc = new AccessException("READ right removed.");
            if (user != null) {
                this.setSave();
                this.subscribers.remove(user);
                this.selectors.remove(user);
                this.forward(user, new ExceptionReply(exc));
            } else {
                Enumeration subs = this.subscribers.elements();
                while (subs.hasMoreElements()) {
                    user = (AgentId)subs.nextElement();
                    if (this.isReader(user)) continue;
                    this.setSave();
                    this.subscribers.remove(user);
                    this.selectors.remove(user);
                    this.forward(user, new ExceptionReply(exc));
                }
            }
            this.postProcess(rightRequest);
        }
    }

    protected void doClientMessages(AgentId from, ClientMessages not) {
        ClientMessages clientMsgs = this.preProcess(from, not);
        if (clientMsgs != null) {
            this.forwardMessages(clientMsgs);
            this.processMessages(clientMsgs);
            this.postProcess(clientMsgs);
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId agId = uA.agent;
        Notification not = uA.not;
        String info = null;
        if (not instanceof ClusterTest) {
            ClusterTest cT = (ClusterTest)not;
            info = this.strbuf.append("Topic [").append(agId).append("] can't join cluster as it does not exist").toString();
            this.strbuf.setLength(0);
            this.forward(cT.requester, new AdminReply(cT.request, false, info));
        } else if (not instanceof FatherTest) {
            FatherTest fT = (FatherTest)not;
            info = this.strbuf.append("Topic [").append(agId).append("] can't join hierarchy as it does not exist").toString();
            this.strbuf.setLength(0);
            this.forward(fT.requester, new AdminReply(fT.request, false, info));
        } else {
            this.setSave();
            this.subscribers.remove(agId);
            this.selectors.remove(agId);
            if (this.fatherId != null && agId.equals(this.fatherId)) {
                this.setSave();
                this.fatherId = null;
            }
        }
    }

    protected void doDeleteNot(DeleteNot not) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            AgentId clientId = (AgentId)this.subscribers.get(i);
            this.forward(clientId, new UnknownAgent(this.getId(), null));
        }
        if (this.friends != null) {
            Iterator iterator = this.friends.iterator();
            while (iterator.hasNext()) {
                this.setSave();
                this.forward((AgentId)iterator.next(), new UnclusterNot());
            }
            this.friends = null;
        }
    }

    protected void forwardMessages(ClientMessages messages) {
        if (this.friends != null && !this.friends.isEmpty()) {
            for (AgentId topicId : this.friends) {
                this.forward(topicId, new TopicForwardNot(messages, false));
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Messages forwarded to fellow " + topicId.toString()));
            }
        } else if (this.fatherId != null) {
            this.forward(this.fatherId, new TopicForwardNot(messages, true));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Messages forwarded to father " + this.fatherId.toString()));
            }
        }
    }

    protected void processMessages(ClientMessages not) {
        Vector<Object> messages = not.getMessages();
        this.nbMsgsReceiveSinceCreation += (long)messages.size();
        this.setNoSave();
        boolean persistent = false;
        Enumeration subs = this.subscribers.elements();
        while (subs.hasMoreElements()) {
            Vector<Object> deliverables;
            AgentId subscriber = (AgentId)subs.nextElement();
            boolean local = subscriber.getTo() == AgentServer.getServerId();
            String selector = (String)this.selectors.get(subscriber);
            if (selector == null || selector.equals("")) {
                if (!local) {
                    deliverables = messages;
                    persistent = true;
                } else if (!this.alreadySentLocally) {
                    deliverables = messages;
                    this.alreadySentLocally = true;
                } else {
                    deliverables = new Vector();
                    Enumeration msgs = messages.elements();
                    while (msgs.hasMoreElements()) {
                        deliverables.add(((Message)msgs.nextElement()).clone());
                    }
                }
            } else {
                deliverables = new Vector<Object>();
                for (int i = 0; i < messages.size(); ++i) {
                    Message message = (Message)messages.get(i);
                    if (!Selector.matches(message, selector)) continue;
                    if (!local) {
                        deliverables.add(message);
                        persistent = true;
                        continue;
                    }
                    if (!this.alreadySentLocally) {
                        deliverables.add(message);
                        this.alreadySentLocally = true;
                        continue;
                    }
                    deliverables.add(message.clone());
                }
            }
            if (deliverables.isEmpty()) continue;
            TopicMsgsReply topicMsgsReply = new TopicMsgsReply(deliverables);
            topicMsgsReply.setPersistent(persistent);
            this.setDmq(topicMsgsReply);
            this.forward(subscriber, topicMsgsReply);
            this.nbMsgsDeliverSinceCreation += (long)deliverables.size();
        }
    }

    private void setDmq(TopicMsgsReply not) {
        if (this.dmqId != null) {
            not.setDMQId(this.dmqId);
        } else {
            not.setDMQId(QueueImpl.getDefaultDMQId());
        }
    }

    public void setAlreadySentLocally(boolean alreadySentLocally) {
        this.alreadySentLocally = alreadySentLocally;
    }

    public long getNbMsgsReceiveSinceCreation() {
        return this.nbMsgsReceiveSinceCreation;
    }
}

