/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class UnitOfWorkValueHolder
extends DatabaseValueHolder {
    protected transient ValueHolderInterface wrappedValueHolder;
    protected transient DatabaseMapping mapping;
    protected ValueHolder backupValueHolder;
    protected UnitOfWorkImpl remoteUnitOfWork;
    protected Object sourceObject;
    protected transient Object relationshipSourceObject;
    protected String sourceAttributeName;
    protected ObjID wrappedValueHolderRemoteID;

    protected UnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object clone, DatabaseMapping mapping, UnitOfWorkImpl unitOfWork) {
        this.wrappedValueHolder = attributeValue;
        this.mapping = mapping;
        this.session = unitOfWork;
        this.sourceAttributeName = mapping.getAttributeName();
        this.relationshipSourceObject = clone;
        if (unitOfWork.isRemoteUnitOfWork()) {
            if (attributeValue instanceof RemoteValueHolder) {
                this.wrappedValueHolderRemoteID = ((RemoteValueHolder)attributeValue).getID();
            }
            this.remoteUnitOfWork = unitOfWork;
            this.sourceObject = clone;
        }
    }

    protected abstract Object buildBackupCloneFor(Object var1);

    public abstract Object buildCloneFor(Object var1);

    protected ValueHolder getBackupValueHolder() {
        return this.backupValueHolder;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected UnitOfWorkImpl getRemoteUnitOfWork() {
        return this.remoteUnitOfWork;
    }

    protected String getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    protected Object getSourceObject() {
        return this.sourceObject;
    }

    protected Object getRelationshipSourceObject() {
        return this.relationshipSourceObject;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return (UnitOfWorkImpl)this.getSession();
    }

    protected Object getValueFromServerObject() {
        this.setSession(this.getRemoteUnitOfWork());
        Vector primaryKey = this.getSession().keyFromObject(this.getSourceObject());
        Object originalObject = this.getUnitOfWork().getParent().getIdentityMapAccessor().getFromIdentityMap(primaryKey, this.getSourceObject().getClass());
        if (originalObject == null) {
            originalObject = this.getUnitOfWork().getParent().readObject(this.getSourceObject());
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(originalObject);
        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getSourceAttributeName());
        this.setMapping(mapping);
        return this.getMapping().getRealAttributeValueFromObject(originalObject, this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateImpl() {
        if (this.getWrappedValueHolder() instanceof DatabaseValueHolder) {
            ValueHolderInterface valueHolderInterface = this.getWrappedValueHolder();
            synchronized (valueHolderInterface) {
                DatabaseValueHolder wrapped = (DatabaseValueHolder)this.getWrappedValueHolder();
                UnitOfWorkImpl unitOfWork = this.getUnitOfWork();
                if (!wrapped.isEasilyInstantiated()) {
                    if (wrapped.isPessimisticLockingValueHolder()) {
                        if (!unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                            unitOfWork.beginEarlyTransaction();
                        }
                        unitOfWork.log(1, "transaction", "instantiate_pl_relationship");
                    }
                    if (unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely()) {
                        return wrapped.instantiateForUnitOfWorkValueHolder(this);
                    }
                }
            }
        }
        Object originalAttributeValue = this.getWrappedValueHolder().getValue();
        return this.buildCloneFor(originalAttributeValue);
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isEasilyInstantiated();
    }

    public boolean isPessimisticLockingValueHolder() {
        return this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isPessimisticLockingValueHolder();
    }

    public ValueHolderInterface getWrappedValueHolder() {
        return this.wrappedValueHolder;
    }

    public ObjID getWrappedValueHolderRemoteID() {
        return this.wrappedValueHolderRemoteID;
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return this.getRemoteUnitOfWork() != null && this.getRemoteUnitOfWork().getParent() != null && this.getWrappedValueHolder() == null;
    }

    protected Object instantiate() {
        Object cloneAttributeValue;
        UnitOfWorkImpl unitOfWork = this.isSerializedRemoteUnitOfWorkValueHolder() ? this.getRemoteUnitOfWork() : this.getUnitOfWork();
        if (unitOfWork == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        if (this.isSerializedRemoteUnitOfWorkValueHolder()) {
            Object originalAttributeValue = this.getValueFromServerObject();
            cloneAttributeValue = this.buildCloneFor(originalAttributeValue);
        } else {
            cloneAttributeValue = this.instantiateImpl();
        }
        if (this.getBackupValueHolder() != null) {
            this.getBackupValueHolder().setValue(this.buildBackupCloneFor(cloneAttributeValue));
        }
        return cloneAttributeValue;
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate();
    }

    public void releaseWrappedValueHolder() {
    }

    protected void resetFields() {
    }

    public void setBackupValueHolder(ValueHolder backupValueHolder) {
        this.backupValueHolder = backupValueHolder;
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    protected void setRemoteUnitOfWork(UnitOfWorkImpl remoteUnitOfWork) {
        this.remoteUnitOfWork = remoteUnitOfWork;
    }

    protected void setSourceAttributeName(String name) {
        this.sourceAttributeName = name;
    }

    protected void setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
    }

    protected void setRelationshipSourceObject(Object relationshipSourceObject) {
        this.relationshipSourceObject = relationshipSourceObject;
    }

    protected void setWrappedValueHolder(DatabaseValueHolder valueHolder) {
        this.wrappedValueHolder = valueHolder;
    }

    public boolean shouldAllowInstantiationDeferral() {
        return ((WeavedAttributeValueHolderInterface)this.wrappedValueHolder).shouldAllowInstantiationDeferral();
    }
}

