/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.impl.DefaultExchangeHolder;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsBinding {
    private static final transient Log LOG = LogFactory.getLog(JmsBinding.class);
    private final JmsEndpoint endpoint;
    private final HeaderFilterStrategy headerFilterStrategy;
    private final JmsKeyFormatStrategy jmsKeyFormatStrategy;

    public JmsBinding() {
        this.endpoint = null;
        this.headerFilterStrategy = new JmsHeaderFilterStrategy();
        this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
    }

    public JmsBinding(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
        this.headerFilterStrategy = endpoint.getHeaderFilterStrategy() != null ? endpoint.getHeaderFilterStrategy() : new JmsHeaderFilterStrategy();
        this.jmsKeyFormatStrategy = endpoint.getJmsKeyFormatStrategy() != null ? endpoint.getJmsKeyFormatStrategy() : new DefaultJmsKeyFormatStrategy();
    }

    public Object extractBodyFromJms(Exchange exchange, javax.jms.Message message) {
        try {
            if (this.endpoint != null && this.endpoint.getMessageConverter() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body using a custom MessageConverter: " + this.endpoint.getMessageConverter() + " from JMS message: " + message));
                }
                return this.endpoint.getMessageConverter().fromMessage(message);
            }
            if (this.endpoint != null && !this.endpoint.getConfiguration().isMapJmsMessage()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Option map JMS message is false so using JMS message as body: " + message));
                }
                return message;
            }
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage;
                Serializable payload;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body as a ObjectMessage from JMS message: " + message));
                }
                if ((payload = (objectMessage = (ObjectMessage)message).getObject()) instanceof DefaultExchangeHolder) {
                    DefaultExchangeHolder holder = (DefaultExchangeHolder)payload;
                    DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
                    return exchange.getIn().getBody();
                }
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body as a TextMessage from JMS message: " + message));
                }
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body as a MapMessage from JMS message: " + message));
                }
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body as a BytesMessage from JMS message: " + message));
                }
                return this.createByteArrayFromBytesMessage((BytesMessage)message);
            }
            if (message instanceof StreamMessage) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Extracting body as a StreamMessage from JMS message: " + message));
                }
                return message;
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + (Object)((Object)e) + ". Message: " + message, (Throwable)e);
        }
    }

    public Map<String, Object> extractHeadersFromJms(javax.jms.Message jmsMessage, Exchange exchange) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jmsMessage != null) {
            Enumeration names;
            try {
                map.put("JMSCorrelationID", jmsMessage.getJMSCorrelationID());
                map.put("JMSDeliveryMode", jmsMessage.getJMSDeliveryMode());
                map.put("JMSDestination", jmsMessage.getJMSDestination());
                map.put("JMSExpiration", jmsMessage.getJMSExpiration());
                map.put("JMSMessageID", jmsMessage.getJMSMessageID());
                map.put("JMSPriority", jmsMessage.getJMSPriority());
                map.put("JMSRedelivered", jmsMessage.getJMSRedelivered());
                map.put("JMSReplyTo", jmsMessage.getJMSReplyTo());
                map.put("JMSTimestamp", jmsMessage.getJMSTimestamp());
                map.put("JMSType", jmsMessage.getJMSType());
                map.put("JMSXGroupID", jmsMessage.getStringProperty("JMSXGroupID"));
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            try {
                names = jmsMessage.getPropertyNames();
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                try {
                    Object value = jmsMessage.getObjectProperty(name);
                    if (this.headerFilterStrategy != null && this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    String key = this.jmsKeyFormatStrategy.decodeKey(name);
                    map.put(key, value);
                }
                catch (JMSException e) {
                    throw new RuntimeCamelException(name, (Throwable)e);
                }
            }
        }
        return map;
    }

    public Object getObjectProperty(javax.jms.Message jmsMessage, String name) throws JMSException {
        Object answer = jmsMessage.getObjectProperty(name);
        if (answer == null) {
            String key = this.jmsKeyFormatStrategy.encodeKey(name);
            answer = jmsMessage.getObjectProperty(key);
        }
        return answer;
    }

    protected byte[] createByteArrayFromBytesMessage(BytesMessage message) throws JMSException {
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            LOG.warn((Object)("Length of BytesMessage is too long: " + message.getBodyLength()));
            return null;
        }
        byte[] result = new byte[(int)message.getBodyLength()];
        message.readBytes(result);
        return result;
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Session session) throws JMSException {
        return this.makeJmsMessage(exchange, exchange.getIn(), session, null);
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Message camelMessage, Session session, Exception cause) throws JMSException {
        JmsMessage jmsMessage;
        boolean alwaysCopy;
        javax.jms.Message answer = null;
        boolean bl = alwaysCopy = this.endpoint != null && this.endpoint.getConfiguration().isAlwaysCopyMessage();
        if (!alwaysCopy && camelMessage instanceof JmsMessage && !(jmsMessage = (JmsMessage)camelMessage).shouldCreateNewMessage()) {
            answer = jmsMessage.getJmsMessage();
        }
        if (answer == null) {
            if (cause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will create JmsMessage with caused exception: " + cause));
                }
                answer = this.createJmsMessage(cause, session);
            } else {
                ObjectHelper.notNull((Object)camelMessage, (String)"message");
                answer = this.createJmsMessage(exchange, camelMessage.getBody(), camelMessage.getHeaders(), session, exchange.getContext());
                this.appendJmsProperties(answer, exchange, camelMessage);
            }
        }
        return answer;
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange) throws JMSException {
        this.appendJmsProperties(jmsMessage, exchange, exchange.getIn());
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange, Message in) throws JMSException {
        Set entries = in.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            this.appendJmsProperty(jmsMessage, exchange, in, headerName, headerValue);
        }
    }

    public void appendJmsProperty(javax.jms.Message jmsMessage, Exchange exchange, Message in, String headerName, Object headerValue) throws JMSException {
        if (this.isStandardJMSHeader(headerName)) {
            if (headerName.equals("JMSCorrelationID")) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSReplyTo") && headerValue != null) {
                jmsMessage.setJMSReplyTo((Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, (Object)headerValue));
            } else if (headerName.equals("JMSType")) {
                jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSPriority")) {
                jmsMessage.setJMSPriority(((Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)headerValue)).intValue());
            } else if (headerName.equals("JMSDeliveryMode")) {
                Integer deliveryMode = (Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)headerValue);
                jmsMessage.setJMSDeliveryMode(deliveryMode.intValue());
                jmsMessage.setIntProperty("CamelJmsDeliveryMode", deliveryMode.intValue());
            } else if (headerName.equals("JMSExpiration")) {
                jmsMessage.setJMSExpiration(((Long)ExchangeHelper.convertToType((Exchange)exchange, Long.class, (Object)headerValue)).longValue());
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ignoring JMS header: " + headerName + " with value: " + headerValue));
            }
        } else if (this.shouldOutputHeader(in, headerName, headerValue, exchange)) {
            Object value = this.getValidJMSHeaderValue(headerName, headerValue);
            if (value != null) {
                String key = this.jmsKeyFormatStrategy.encodeKey(headerName);
                JmsMessageHelper.setProperty(jmsMessage, key, value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring non primitive header: " + headerName + " of class: " + headerValue.getClass().getName() + " with value: " + headerValue));
            }
        }
    }

    protected boolean isStandardJMSHeader(String headerName) {
        Character fourth;
        if (!headerName.startsWith("JMS")) {
            return false;
        }
        if (headerName.startsWith("JMSX")) {
            return false;
        }
        if (headerName.startsWith("JMS_")) {
            return false;
        }
        return headerName.length() > 3 && Character.isLetter((fourth = Character.valueOf(headerName.charAt(3))).charValue());
    }

    protected Object getValidJMSHeaderValue(String headerName, Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Character) {
            return headerValue;
        }
        if (headerValue instanceof CharSequence) {
            return headerValue.toString();
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue.toString();
        }
        return null;
    }

    protected javax.jms.Message createJmsMessage(Exception cause, Session session) throws JMSException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using JmsMessageType: " + (Object)((Object)JmsMessageType.Object)));
        }
        return session.createObjectMessage((Serializable)cause);
    }

    protected javax.jms.Message createJmsMessage(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context) throws JMSException {
        JmsMessageType type = null;
        if (this.endpoint != null && this.endpoint.isTransferExchange()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Option transferExchange=true so we use JmsMessageType: Object");
            }
            DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange);
            return session.createObjectMessage((Serializable)holder);
        }
        if (this.endpoint != null && this.endpoint.getMessageConverter() != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Creating JmsMessage using a custom MessageConverter: " + this.endpoint.getMessageConverter() + " with body: " + body));
            }
            return this.endpoint.getMessageConverter().toMessage(body, session);
        }
        if (headers.containsKey("CamelJmsMessageType")) {
            type = (JmsMessageType)((Object)context.getTypeConverter().convertTo(JmsMessageType.class, headers.get("CamelJmsMessageType")));
        } else if (this.endpoint != null && this.endpoint.getConfiguration().getJmsMessageType() != null) {
            type = this.endpoint.getConfiguration().getJmsMessageType();
        } else if (body instanceof Node || body instanceof String) {
            type = JmsMessageType.Text;
        } else if (body instanceof byte[] || body instanceof GenericFile || body instanceof File || body instanceof Reader || body instanceof InputStream || body instanceof ByteBuffer || body instanceof StreamCache) {
            type = JmsMessageType.Bytes;
        } else if (body instanceof Map) {
            type = JmsMessageType.Map;
        } else if (body instanceof Serializable) {
            type = JmsMessageType.Object;
        }
        if (type != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using JmsMessageType: " + (Object)((Object)type)));
            }
            switch (type) {
                case Text: {
                    TextMessage message = session.createTextMessage();
                    String payload = (String)context.getTypeConverter().convertTo(String.class, exchange, body);
                    message.setText(payload);
                    return message;
                }
                case Bytes: {
                    BytesMessage message = session.createBytesMessage();
                    byte[] payload = (byte[])context.getTypeConverter().convertTo(byte[].class, exchange, body);
                    message.writeBytes(payload);
                    return message;
                }
                case Map: {
                    MapMessage message = session.createMapMessage();
                    Map payload = (Map)context.getTypeConverter().convertTo(Map.class, exchange, body);
                    this.populateMapMessage(message, payload, context);
                    return message;
                }
                case Object: {
                    Serializable payload;
                    try {
                        payload = (Serializable)context.getTypeConverter().mandatoryConvertTo(Serializable.class, exchange, body);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        MessageFormatException cause = new MessageFormatException(e.getMessage());
                        cause.initCause((Throwable)e);
                        throw cause;
                    }
                    return session.createObjectMessage(payload);
                }
            }
        }
        if (body != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Cannot determine specific JmsMessage type to use from body class. Will use generic JmsMessage. Body class: " + ObjectHelper.classCanonicalName((Object)body) + ". If you want to send a POJO then your class might need to implement java.io.Serializable" + ", or you can force a specific type by setting the jmsMessageType option on the JMS endpoint."));
        }
        return session.createMessage();
    }

    protected void populateMapMessage(MapMessage message, Map<?, ?> map, CamelContext context) throws JMSException {
        for (Object key : map.keySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, key);
            if (keyString == null) continue;
            message.setObject(keyString, map.get(key));
        }
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }
}

