/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.jorm.lib.CompositePName;
import org.objectweb.medor.filter.jorm.lib.SinglePName;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.optim.api.LeafRewriter;
import org.objectweb.medor.optim.jorm.JormRule;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.lib.Project;

public abstract class JormLeafRewriter
extends JormRule
implements LeafRewriter {
    public JormLeafRewriter(String suffix) {
        super(suffix);
    }

    public abstract boolean canRewrite(QueryLeaf var1);

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        throw new UnsupportedOperationException("A leaf rewriter only rewrites leaves, not nodes.");
    }

    public QueryTree rewrite(QueryLeaf ql) throws MedorException {
        if (!this.canRewrite(ql)) {
            throw new MedorException("Impossible to rewrite this QueryLeaf: " + ql);
        }
        JormExtent extent = (JormExtent)ql;
        QueryLeaf specificQL = this.createQueryLeaf(extent);
        Project qt = new Project("");
        Field[] oldFields = ql.getTupleStructure().getFields();
        for (int i = 0; i < oldFields.length; ++i) {
            if (oldFields[i] instanceof PNameField) {
                PNameField pnf = (PNameField)oldFields[i];
                NameDef nd = pnf.getNameDef(extent);
                this.addReference(nd, pnf, qt, specificQL, extent);
                continue;
            }
            PrimitiveElement pe = this.getPrimitiveElement(extent, this.getShortFieldName(oldFields[i].getName()));
            QueryTreeField qtf = this.getField(specificQL, pe, extent);
            qt.addPropagatedField(qtf.getName(), qtf.getType(), new QueryTreeField[]{qtf});
        }
        return qt;
    }

    protected abstract QueryLeaf createQueryLeaf(JormExtent var1) throws MedorException;

    public abstract QueryTreeField addPrimitiveElement(QueryLeaf var1, PrimitiveElement var2, JormExtent var3) throws MedorException;

    public QueryTreeField getField(QueryLeaf neo, PrimitiveElement pe, JormExtent extent) throws MedorException {
        if (neo.getTupleStructure().contains(pe.getName())) {
            return (QueryTreeField)neo.getTupleStructure().getField(pe.getName());
        }
        return this.addPrimitiveElement(neo, pe, extent);
    }

    protected void addReference(NameDef nd, PNameField pnf, QueryNode qt, QueryLeaf specificQL, JormExtent extent) throws MedorException {
        Operand o = this.getPNCOperand(extent, pnf);
        PType type = pnf.getType();
        QueryTreeField qtf = null;
        if (nd.isFieldName()) {
            String ndfn = this.getFieldName(specificQL.getName(), nd.getFieldName());
            PrimitiveElement pe = this.getPrimitiveElement(extent, ndfn);
            qtf = this.getField(specificQL, pe, extent);
            SinglePName e = new SinglePName(new BasicFieldOperand(qtf), o, type);
            qt.addCalculatedField(pnf.getName(), type, e);
        } else if (nd.isNameRef()) {
            Map proj = nd.getNameRef().getProjection();
            FieldOperand[] fos = new BasicFieldOperand[proj.size()];
            String[] cofns = new String[proj.size()];
            int counter = 0;
            Iterator it = proj.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                cofns[counter] = (String)me.getKey();
                String clafn = (String)me.getValue();
                String ndfn = this.getFieldName(specificQL.getName(), clafn);
                qtf = this.getField(specificQL, this.getPrimitiveElement(extent, ndfn), extent);
                fos[counter] = new BasicFieldOperand(qtf);
                ++counter;
            }
            CompositePName e = new CompositePName(fos, cofns, o, type);
            qt.addCalculatedField(pnf.getName(), type, e);
        }
    }

    protected String getFieldName(String prefix, String nodeName) {
        if (prefix == null || prefix.length() == 0) {
            return nodeName;
        }
        return prefix + "." + nodeName;
    }

    protected String getShortFieldName(String fn) {
        return fn.substring(fn.lastIndexOf(".") + 1, fn.length());
    }
}

