/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.cache.lib;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.perseus.cache.api.CacheAttributeController;
import org.objectweb.perseus.cache.api.CacheCapacityEvent;
import org.objectweb.perseus.cache.api.CacheCapacityEventListener;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheEntryFactory;
import org.objectweb.perseus.cache.api.CacheEntryFilter;
import org.objectweb.perseus.cache.api.CacheEvent;
import org.objectweb.perseus.cache.api.CacheEventListener;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.cache.api.FixableCacheEntry;
import org.objectweb.perseus.cache.api.InvalidCacheEntryException;
import org.objectweb.perseus.cache.api.UnbindManager;
import org.objectweb.perseus.cache.lib.BackgroundCleaner;
import org.objectweb.perseus.cache.replacement.api.ReplacementManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class BasicCacheManager
implements CacheManager,
UnbindManager,
BindingController,
LifeCycleController,
CacheAttributeController {
    public static final String DEFAULT_AUTO_CLEAN_SIZE = "7%";
    public static final String CACHE_ENTRY_FACTORY_BINDING = "cache-entry-factory";
    public static final String REPLACEMENT_MANAGER_BINDING = "replacement-manager";
    public static final String CACHE_LISTENER_BINDING = "cache-listeners";
    public static final String CACHE_CAPACTITY_LISTENER_BINDING = "cache-capacity-listeners";
    protected CacheEntryFactory cef = null;
    protected ReplacementManager rm = null;
    protected Map cache;
    protected ReferenceQueue queue;
    protected int cacheMaxSize = -1;
    private BackgroundCleaner bgcleaner;
    protected int cacheThresHold = 0;
    protected String cacheThresHoldStr;
    protected Logger logger = null;
    protected Logger bgclogger = null;
    protected HashMap cels = new HashMap();
    protected HashMap ccels = new HashMap();
    private String autoCleanSizeStr = null;
    private int autoCleanSize;
    private boolean started = false;
    private static final int NB_CALL_BEFORE_ACTUAL_CLEAN = 2;
    private int nbClean = 0;
    private static final int TIMEOUTINMILLISECONDS = 50;

    public BasicCacheManager() {
        this.cache = new HashMap();
        this.queue = new ReferenceQueue();
    }

    public BackgroundCleaner getBgcleaner() {
        if (this.bgcleaner == null && this.cacheThresHold > 0) {
            this.bgcleaner = new BackgroundCleaner(this.rm, this.bgclogger);
        }
        return this.bgcleaner;
    }

    public String getFcState() {
        return this.started ? "STARTED" : "STOPPED";
    }

    public void startFc() {
        if (!this.started) {
            this.started = true;
            this.autoCleanSize = this.getValue(this.autoCleanSizeStr);
            this.cacheThresHold = this.getValue(this.cacheThresHoldStr);
            CapacityEvent ev = new CapacityEvent(1, -1, this.cacheMaxSize);
            Iterator it = this.ccels.values().iterator();
            while (it.hasNext()) {
                ((CacheCapacityEventListener)it.next()).cacheResized(ev);
            }
        }
    }

    public void stopFc() {
        if (this.started) {
            this.started = false;
            try {
                this.setMaxObjects(0);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    public String[] listFc() {
        HashSet<String> itfs = new HashSet<String>();
        itfs.add(CACHE_ENTRY_FACTORY_BINDING);
        itfs.add(REPLACEMENT_MANAGER_BINDING);
        itfs.add(CACHE_LISTENER_BINDING);
        itfs.add(CACHE_CAPACTITY_LISTENER_BINDING);
        return itfs.toArray(new String[itfs.size()]);
    }

    public Object lookupFc(String s) {
        if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            return this.cef;
        }
        if (REPLACEMENT_MANAGER_BINDING.equals(s)) {
            return this.rm;
        }
        if (s.startsWith(CACHE_LISTENER_BINDING)) {
            return this.cels.get(s);
        }
        if (s.startsWith(CACHE_CAPACTITY_LISTENER_BINDING)) {
            return this.ccels.get(s);
        }
        return null;
    }

    public void bindFc(String s, Object o) {
        if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            this.cef = (CacheEntryFactory)o;
        } else if (REPLACEMENT_MANAGER_BINDING.equals(s)) {
            this.rm = (ReplacementManager)o;
        } else if (s.startsWith(CACHE_LISTENER_BINDING)) {
            this.cels.put(s, o);
        } else if (s.startsWith(CACHE_CAPACTITY_LISTENER_BINDING)) {
            this.ccels.put(s, o);
        } else if ("monolog-factory".equals(s)) {
            this.bgclogger = ((LoggerFactory)o).getLogger(this.logger.getName() + ".bgcleaner");
        } else if ("logger".equals(s)) {
            this.logger = (Logger)o;
        }
    }

    public void unbindFc(String s) {
        if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            this.cef = null;
        } else if (REPLACEMENT_MANAGER_BINDING.equals(s)) {
            this.rm = null;
            if (this.bgcleaner != null) {
                this.bgcleaner.stop();
                this.bgcleaner = null;
            }
        } else if (s.startsWith(CACHE_LISTENER_BINDING)) {
            this.cels.remove(s);
        } else if (s.startsWith(CACHE_CAPACTITY_LISTENER_BINDING)) {
            this.ccels.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxObjects(int size) throws IllegalArgumentException, CacheException {
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("resize the cache: " + (size == -1 ? "UNLIMITED" : "" + size)));
        }
        if (size == -1) {
            this.cacheMaxSize = -1;
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Impossible to set the cache size to a negative value: " + size);
        }
        Map map = this.cache;
        synchronized (map) {
            int free;
            int delta;
            CapacityEvent ev = new CapacityEvent(1, this.cacheMaxSize, size);
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("resize the cache: " + this.cacheMaxSize + " to " + size + " (Nd elem=" + this.cache.size() + ")"));
            }
            if ((delta = size - this.cache.size()) < 0 && (delta = -delta) > (free = this.rm.forceFree(delta)) && this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("It stays " + (delta - free) + " entries which have not been freed"));
            }
            this.cacheMaxSize = size;
            if (this.started) {
                Iterator it = this.ccels.values().iterator();
                while (it.hasNext()) {
                    ((CacheCapacityEventListener)it.next()).cacheResized(ev);
                }
            } else {
                Map old = this.cache;
                this.cache = new HashMap(this.cacheMaxSize, 1.0f);
                if (old.size() > 0) {
                    this.cache.putAll(old);
                }
            }
        }
    }

    public int getMaxObjects() {
        return this.cacheMaxSize;
    }

    public int getCurrentSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCurrentEntryIdentifiers() {
        Map map = this.cache;
        synchronized (map) {
            if (this.cache.size() == 0) {
                return Collections.EMPTY_SET;
            }
            return Collections.unmodifiableCollection(this.cache.keySet());
        }
    }

    public void setMemorySize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Impossible to set the cache size to a negative value: " + size);
        }
    }

    public int getMemorySize() {
        return 0;
    }

    public int getCurrentMemorySize() {
        return 0;
    }

    public void setAutoCleanSize(String size) {
        this.autoCleanSizeStr = size;
        this.autoCleanSize = this.getValue(this.autoCleanSizeStr);
    }

    public String getAutoCleanSize() {
        return this.autoCleanSizeStr;
    }

    public void setAutoCleanThreshold(String size) {
        this.cacheThresHoldStr = size;
        this.cacheThresHold = this.getValue(this.cacheThresHoldStr);
    }

    public String getAutoCleanThreshold() {
        return this.cacheThresHoldStr;
    }

    private int getValue(String str) {
        int i;
        if (this.cacheMaxSize == -1) {
            return 0;
        }
        if (str == null) {
            str = "75%";
        }
        if ((i = str.indexOf(37)) == -1) {
            return Integer.parseInt(str);
        }
        int res = Integer.parseInt(str.substring(0, i));
        return this.cacheMaxSize * res / 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry bind(Object id, Object object) throws CacheException {
        if (id == null || object == null) {
            throw new IllegalArgumentException("Impossible to add a cache entry with a null identifier or object");
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("bind an element in the cache, id:" + id));
        }
        Map map = this.cache;
        synchronized (map) {
            FixableCacheEntry entry;
            WeakCacheEntry ref;
            this.clean();
            int size = this.cache.size();
            if (this.cacheMaxSize != -1) {
                if (size >= this.cacheMaxSize) {
                    this.rm.forceFree(this.autoCleanSize);
                    if (this.cache.size() >= this.cacheMaxSize) {
                        this.forceClean();
                        size = this.cache.size();
                        if (size >= this.cacheMaxSize) {
                            this.logger.log(BasicLevel.WARN, (Object)("The cache is still full after cleaning: number of exceeded entries is " + (size - this.cacheMaxSize)));
                        }
                    }
                } else if (size + 1 >= this.cacheThresHold && this.getBgcleaner() != null) {
                    this.getBgcleaner().backgroungCleanup(this.autoCleanSize);
                }
            }
            if ((ref = (WeakCacheEntry)this.cache.get(id)) != null && (entry = (FixableCacheEntry)ref.get()) != null && ref.ce != null) {
                throw new CacheException("Identifier is already bound with " + (entry.getCeObject() == object ? "the same" : "another") + " object: \nid=" + id);
            }
            FixableCacheEntry ce = this.cef.create(id, object);
            this.cache.put(id, new WeakCacheEntry(ce, this.queue));
            this.rm.addForReplacement(ce);
            Event ev = new Event(1, ce, this.cache.size());
            this.logger.log(BasicLevel.DEBUG, (Object)"notify the bind");
            Iterator it = this.cels.values().iterator();
            while (it.hasNext()) {
                ((CacheEventListener)it.next()).entryBound(ev);
            }
            return ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry lookup(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Impossible to find cache entry with a null identifier");
        }
        Map map = this.cache;
        synchronized (map) {
            try {
                FixableCacheEntry ce = this.get(id);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("lookup: id=" + id));
                }
                return ce;
            }
            catch (InvalidCacheEntryException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fix(CacheEntry _ce) throws CacheException {
        if (_ce == null) {
            throw new IllegalArgumentException("Impossible to fix a null cache entry");
        }
        CacheEntry cacheEntry = _ce;
        synchronized (cacheEntry) {
            FixableCacheEntry ce = this.get(_ce.getCeIdentifier());
            ce.fixCe();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Fix an element in the cache, id:" + ce.getCeIdentifier() + " / count:" + ce.getCeFixCount()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fix(CacheEntryFilter filter) throws CacheException {
        Map map = this.cache;
        synchronized (map) {
            Iterator iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                CacheEntry ce = (CacheEntry)iter.next();
                if (!filter.accept(ce)) continue;
                this.fix(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfix(CacheEntry ce) throws CacheException {
        if (ce == null) {
            throw new IllegalArgumentException("Impossible to unfix a null cache entry");
        }
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            ((FixableCacheEntry)ce).unfixCe();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("UnFix an element in the cache, id:" + ce.getCeIdentifier() + " / count:" + ((FixableCacheEntry)ce).getCeFixCount()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfix(CacheEntryFilter filter) throws CacheException {
        Map map = this.cache;
        synchronized (map) {
            Iterator iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                CacheEntry ce = (CacheEntry)iter.next();
                if (!filter.accept(ce)) continue;
                this.unfix(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(CacheEntry ce) throws CacheException {
        if (ce == null) {
            throw new IllegalArgumentException("Impossible to touch a null cache entry");
        }
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            this.rm.adjustForReplacement((FixableCacheEntry)ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() throws CacheException {
        Map map = this.cache;
        synchronized (map) {
            this.rm.unbindAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(Object oid, boolean force) throws CacheException {
        Map map = this.cache;
        synchronized (map) {
            return this._unbind(oid, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _unbind(Object oid, boolean force) throws CacheException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Unbind an element from the cache, id:" + oid));
        }
        this.clean();
        WeakCacheEntry ref = (WeakCacheEntry)this.cache.get(oid);
        if (ref == null) {
            return true;
        }
        FixableCacheEntry ce = (FixableCacheEntry)ref.get();
        if (ce == null) {
            throw new InvalidCacheEntryException();
        }
        FixableCacheEntry fixableCacheEntry = ce;
        synchronized (fixableCacheEntry) {
            if (ce.getCeFixCount() > 0) {
                return false;
            }
            ref.ce = null;
            if (force) {
                this.cache.remove(oid);
                Event ev = new Event(2, oid, this.cache.size());
                Iterator it = this.cels.values().iterator();
                while (it.hasNext()) {
                    ((CacheEventListener)it.next()).entryUnbound(ev);
                }
                this.rm.removeForReplacement(oid);
            }
            return force;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection unbind(CacheEntryFilter filter, boolean force) throws CacheException {
        ArrayList<Object> res = new ArrayList<Object>();
        Map map = this.cache;
        synchronized (map) {
            Iterator iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                CacheEntry ce = (CacheEntry)iter.next();
                if (!filter.accept(ce)) continue;
                Object oid = ce.getCeIdentifier();
                if (!this._unbind(ce, force)) continue;
                res.add(oid);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection unbindAll(Collection oids, boolean force) throws CacheException {
        ArrayList unbound = new ArrayList(oids.size());
        Map map = this.cache;
        synchronized (map) {
            Object oid;
            if (this.cache.size() == 0) {
                unbound.addAll(oids);
                return unbound;
            }
            Iterator it = oids.iterator();
            while (it.hasNext()) {
                oid = it.next();
                if (unbound.contains(oid) || this.lookup(oid) != null && !this._unbind(oid, force)) continue;
                unbound.add(oid);
            }
            if (!force) {
                this.forceClean();
                this.clean();
                if (this.cache.size() == 0) {
                    unbound = new ArrayList(oids);
                    return unbound;
                }
                it = oids.iterator();
                while (it.hasNext()) {
                    oid = it.next();
                    WeakCacheEntry ref = (WeakCacheEntry)this.cache.get(oid);
                    if (ref != null || unbound.contains(oid)) continue;
                    unbound.add(oid);
                }
            }
        }
        return unbound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll(boolean force) throws CacheException {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
            if (!force) {
                this.forceClean();
                this.clean();
            }
        }
    }

    public Collection unbindUnfixed(boolean force) throws CacheException {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FixableCacheEntry get(Object id) throws InvalidCacheEntryException {
        FixableCacheEntry entry;
        Reference ref = (Reference)this.cache.get(id);
        if (ref == null) {
            Map map = this.cache;
            synchronized (map) {
                ref = (Reference)this.cache.get(id);
            }
            if (ref == null) {
                throw new InvalidCacheEntryException(id);
            }
        }
        if ((entry = (FixableCacheEntry)ref.get()) == null) {
            throw new InvalidCacheEntryException();
        }
        ((WeakCacheEntry)ref).ce = entry;
        return entry;
    }

    private void clean() throws CacheException {
        WeakCacheEntry ref;
        if (this.cacheMaxSize != -1) {
            if (this.cache.size() < this.cacheThresHold && this.nbClean < 2) {
                ++this.nbClean;
                return;
            }
        } else if (this.nbClean < 2) {
            ++this.nbClean;
            return;
        }
        this.nbClean = 0;
        while ((ref = (WeakCacheEntry)this.queue.poll()) != null && ref.ce == null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Really remove from the cache, id:" + ref.getIdentifier()));
            }
            Object oid = ref.getIdentifier();
            this.cache.remove(oid);
            Event ev = new Event(2, oid, this.cache.size());
            Iterator it = this.cels.values().iterator();
            while (it.hasNext()) {
                ((CacheEventListener)it.next()).entryUnbound(ev);
            }
            this.rm.removeForReplacement(oid);
        }
    }

    private void forceClean() {
        this.logger.log(BasicLevel.DEBUG, (Object)"forceClean()");
        for (int i = 0; i < 6; ++i) {
            System.gc();
            WeakCacheEntry ref = null;
            try {
                ref = (WeakCacheEntry)this.queue.remove(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (ref == null) continue;
            Object oid = ref.getIdentifier();
            this.cache.remove(oid);
            Event ev = new Event(2, oid, this.cache.size());
            Iterator it = this.cels.values().iterator();
            while (it.hasNext()) {
                ((CacheEventListener)it.next()).entryUnbound(ev);
            }
            this.rm.removeForReplacement(oid);
            return;
        }
    }

    private static class WeakCacheEntry
    extends WeakReference {
        private final Object id;
        public CacheEntry ce;

        public WeakCacheEntry(CacheEntry ce, ReferenceQueue queue) {
            super(ce, queue);
            this.id = ce.getCeIdentifier();
            this.ce = ce;
        }

        public Object getIdentifier() {
            return this.id;
        }
    }

    protected class CapacityEvent
    implements CacheCapacityEvent {
        public int eventId = 0;
        public int oldCacheSize = -2;
        public int cacheSize = -2;

        public CapacityEvent(int eventid, int oldCacheSize, int cacheSize) {
            this.eventId = eventid;
            this.cacheSize = cacheSize;
            this.oldCacheSize = oldCacheSize;
        }

        public int getEventId() {
            return this.eventId;
        }

        public int getOldSize() {
            return this.oldCacheSize;
        }

        public int getSize() {
            return this.cacheSize;
        }
    }

    protected class Event
    implements CacheEvent {
        public int eventId = 0;
        public CacheEntry ce = null;
        public Object oid = null;
        public int cacheSize = -2;

        public Event(int eventid, Object oid, int cachesize) {
            this.eventId = eventid;
            this.oid = oid;
            this.cacheSize = cachesize;
        }

        public Event(int eventid, CacheEntry _ce, int cachesize) {
            this.eventId = eventid;
            this.ce = _ce;
            this.cacheSize = cachesize;
        }

        public int getEventId() {
            return this.eventId;
        }

        public Object getCeIdentifier() {
            return this.oid;
        }

        public CacheEntry getEntry() {
            return this.ce;
        }
    }
}

