/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.workcleaner.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerException;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.workcleaner.internal.WorkCleanerTimer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASWorkCleanerService
extends AbsServiceImpl
implements WorkCleanerService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private static final int DEFAULT_CLEAN_PERIOD = 300;
    private boolean __Fperiod;
    private int period;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FtaskList;
    private List<CleanTask> taskList;
    public static final String SERVICE_NAME = "workcleaner";
    private boolean __FworkCleanerTimer;
    private WorkCleanerTimer workCleanerTimer;
    static final String PERIOD = "jonas.service.wc.period";
    private boolean __MgetExecutePeriod;
    private boolean __MsetExecutePeriod$int;
    private boolean __MgetPeriod;
    private boolean __MsetPeriod$int;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MregisterTask$org_ow2_jonas_workcleaner_CleanTask;
    private boolean __MunregisterTask$org_ow2_jonas_workcleaner_CleanTask;
    private boolean __MexecuteTasks;
    private boolean __MregisterWorkCleanerMBean$java_lang_Object$java_lang_String;
    private boolean __MunregisterWorkCleanerMBean$java_lang_String;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsaveConfig;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    int __getperiod() {
        if (!this.__Fperiod) {
            return this.period;
        }
        Object object = this.__IM.onGet((Object)this, "period");
        Integer n = (Integer)object;
        return n;
    }

    void __setperiod(int n) {
        if (!this.__Fperiod) {
            this.period = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "period", (Object)n2);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    List __gettaskList() {
        if (!this.__FtaskList) {
            return this.taskList;
        }
        return (List)this.__IM.onGet((Object)this, "taskList");
    }

    void __settaskList(List list) {
        if (!this.__FtaskList) {
            this.taskList = list;
            return;
        }
        this.__IM.onSet((Object)this, "taskList", (Object)list);
    }

    WorkCleanerTimer __getworkCleanerTimer() {
        if (!this.__FworkCleanerTimer) {
            return this.workCleanerTimer;
        }
        return (WorkCleanerTimer)this.__IM.onGet((Object)this, "workCleanerTimer");
    }

    void __setworkCleanerTimer(WorkCleanerTimer workCleanerTimer) {
        if (!this.__FworkCleanerTimer) {
            this.workCleanerTimer = workCleanerTimer;
            return;
        }
        this.__IM.onSet((Object)this, "workCleanerTimer", (Object)workCleanerTimer);
    }

    public int getExecutePeriod() {
        int n;
        if (!this.__MgetExecutePeriod) {
            return this.__getExecutePeriod();
        }
        try {
            this.__IM.onEntry((Object)this, "getExecutePeriod", new Object[0]);
            n = this.__getExecutePeriod();
            this.__IM.onExit((Object)this, "getExecutePeriod", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExecutePeriod", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getExecutePeriod() {
        return this.getPeriod();
    }

    public void setExecutePeriod(int n) {
        if (!this.__MsetExecutePeriod$int) {
            this.__setExecutePeriod(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setExecutePeriod$int", new Object[]{new Integer(n)});
            this.__setExecutePeriod(n);
            this.__IM.onExit((Object)this, "setExecutePeriod$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setExecutePeriod$int", throwable);
            throw throwable;
        }
    }

    private void __setExecutePeriod(int period) {
        this.setPeriod(period);
        String propName = PERIOD;
        String propValue = new Integer(period).toString();
        this.sendReconfigNotification(this.getSequenceNumber(), SERVICE_NAME, new PropertiesConfigurationData(propName, propValue));
    }

    public JOnASWorkCleanerService() {
        this(null);
    }

    private JOnASWorkCleanerService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(JOnASWorkCleanerService.class));
        this.__setperiod(300);
        this.__settaskList(null);
        this.__setworkCleanerTimer(null);
        this.__settaskList(new LinkedList());
        this.__setworkCleanerTimer(new WorkCleanerTimer());
    }

    public int getPeriod() {
        int n;
        if (!this.__MgetPeriod) {
            return this.__getPeriod();
        }
        try {
            this.__IM.onEntry((Object)this, "getPeriod", new Object[0]);
            n = this.__getPeriod();
            this.__IM.onExit((Object)this, "getPeriod", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPeriod", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getPeriod() {
        return this.__getperiod();
    }

    public void setPeriod(int n) {
        if (!this.__MsetPeriod$int) {
            this.__setPeriod(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setPeriod$int", new Object[]{new Integer(n)});
            this.__setPeriod(n);
            this.__IM.onExit((Object)this, "setPeriod$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setPeriod$int", throwable);
            throw throwable;
        }
    }

    private void __setPeriod(int period) {
        this.__setperiod(period);
        this.__getworkCleanerTimer().setPeriod(period);
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        if (this.__getworkCleanerTimer() == null) {
            this.__setworkCleanerTimer(new WorkCleanerTimer());
        }
        this.__getworkCleanerTimer().setWorkCleanerService(this);
        this.__getworkCleanerTimer().setPriority(1);
        this.__getworkCleanerTimer().start();
        this.registerWorkCleanerMBean((Object)this, this.getDomainName());
        this.__getlogger().info((Object)"WorkCleaner Service started.", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        this.__getworkCleanerTimer().setStarted(false);
        this.__setworkCleanerTimer(null);
        if (this.__getjmxService() != null) {
            this.unregisterWorkCleanerMBean(this.getDomainName());
        }
        this.__getlogger().info((Object)"WorkCleaner Service stopped.", new Object[0]);
    }

    public synchronized void registerTask(CleanTask cleanTask) throws WorkCleanerException {
        if (!this.__MregisterTask$org_ow2_jonas_workcleaner_CleanTask) {
            this.__registerTask(cleanTask);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerTask$org_ow2_jonas_workcleaner_CleanTask", new Object[]{cleanTask});
            this.__registerTask(cleanTask);
            this.__IM.onExit((Object)this, "registerTask$org_ow2_jonas_workcleaner_CleanTask", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerTask$org_ow2_jonas_workcleaner_CleanTask", throwable);
            throw throwable;
        }
    }

    private void __registerTask(CleanTask cleanTask) throws WorkCleanerException {
        this.__getlogger().debug((Object)"Register task {0}", new Object[]{cleanTask});
        if (this.__gettaskList() == null) {
            throw new WorkCleanerException("Can not add an entry, the vector is null");
        }
        if (cleanTask == null) {
            throw new WorkCleanerException("Can not add a null entry");
        }
        if (!this.__gettaskList().contains(cleanTask)) {
            this.__gettaskList().add(cleanTask);
        }
    }

    public synchronized void unregisterTask(CleanTask cleanTask) throws WorkCleanerException {
        if (!this.__MunregisterTask$org_ow2_jonas_workcleaner_CleanTask) {
            this.__unregisterTask(cleanTask);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterTask$org_ow2_jonas_workcleaner_CleanTask", new Object[]{cleanTask});
            this.__unregisterTask(cleanTask);
            this.__IM.onExit((Object)this, "unregisterTask$org_ow2_jonas_workcleaner_CleanTask", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterTask$org_ow2_jonas_workcleaner_CleanTask", throwable);
            throw throwable;
        }
    }

    private void __unregisterTask(CleanTask cleanTask) throws WorkCleanerException {
        this.__getlogger().debug((Object)"Unregister task {0}", new Object[]{cleanTask});
        if (this.__gettaskList() == null) {
            throw new WorkCleanerException("Can not unregister an entry, the vector is null");
        }
        if (cleanTask == null) {
            throw new WorkCleanerException("Can not add a null entry");
        }
        if (this.__gettaskList().contains(cleanTask)) {
            this.__gettaskList().remove(cleanTask);
        }
    }

    public synchronized void executeTasks() {
        if (!this.__MexecuteTasks) {
            this.__executeTasks();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "executeTasks", new Object[0]);
            this.__executeTasks();
            this.__IM.onExit((Object)this, "executeTasks", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "executeTasks", throwable);
            throw throwable;
        }
    }

    private void __executeTasks() {
        this.__getlogger().debug((Object)"Execute tasks", new Object[0]);
        for (CleanTask cleanTask : this.__gettaskList()) {
            try {
                cleanTask.execute();
            }
            catch (WorkCleanerException e) {
                e.printStackTrace();
            }
        }
    }

    private void registerWorkCleanerMBean(Object object, String string) {
        if (!this.__MregisterWorkCleanerMBean$java_lang_Object$java_lang_String) {
            this.__registerWorkCleanerMBean(object, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerWorkCleanerMBean$java_lang_Object$java_lang_String", new Object[]{object, string});
            this.__registerWorkCleanerMBean(object, string);
            this.__IM.onExit((Object)this, "registerWorkCleanerMBean$java_lang_Object$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerWorkCleanerMBean$java_lang_Object$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __registerWorkCleanerMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.workCleaner((String)domainName);
        try {
            this.__getjmxService().registerModelMBean(service, on);
        }
        catch (Exception e) {
            this.__getlogger().warn((Object)"Could not register WorkCleaner MBean", new Object[]{e});
        }
    }

    private void unregisterWorkCleanerMBean(String string) {
        if (!this.__MunregisterWorkCleanerMBean$java_lang_String) {
            this.__unregisterWorkCleanerMBean(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterWorkCleanerMBean$java_lang_String", new Object[]{string});
            this.__unregisterWorkCleanerMBean(string);
            this.__IM.onExit((Object)this, "unregisterWorkCleanerMBean$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterWorkCleanerMBean$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unregisterWorkCleanerMBean(String domainName) {
        ObjectName on = JonasObjectName.workCleaner((String)domainName);
        try {
            this.__getjmxService().unregisterModelMBean(on);
        }
        catch (Exception e) {
            this.__getlogger().warn((Object)"Could not unregister WorkCleaner MBean", new Object[]{e});
        }
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void saveConfig() {
        if (!this.__MsaveConfig) {
            this.__saveConfig();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfig", new Object[0]);
            this.__saveConfig();
            this.__IM.onExit((Object)this, "saveConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfig", throwable);
            throw throwable;
        }
    }

    private void __saveConfig() {
        this.sendSaveNotification(this.getSequenceNumber(), SERVICE_NAME);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("taskList")) {
                this.__FtaskList = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("workCleanerTimer")) {
                this.__FworkCleanerTimer = true;
            }
            if (set.contains("period")) {
                this.__Fperiod = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getExecutePeriod")) {
                this.__MgetExecutePeriod = true;
            }
            if (set.contains("setExecutePeriod$int")) {
                this.__MsetExecutePeriod$int = true;
            }
            if (set.contains("getPeriod")) {
                this.__MgetPeriod = true;
            }
            if (set.contains("setPeriod$int")) {
                this.__MsetPeriod$int = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("registerTask$org_ow2_jonas_workcleaner_CleanTask")) {
                this.__MregisterTask$org_ow2_jonas_workcleaner_CleanTask = true;
            }
            if (set.contains("unregisterTask$org_ow2_jonas_workcleaner_CleanTask")) {
                this.__MunregisterTask$org_ow2_jonas_workcleaner_CleanTask = true;
            }
            if (set.contains("executeTasks")) {
                this.__MexecuteTasks = true;
            }
            if (set.contains("registerWorkCleanerMBean$java_lang_Object$java_lang_String")) {
                this.__MregisterWorkCleanerMBean$java_lang_Object$java_lang_String = true;
            }
            if (set.contains("unregisterWorkCleanerMBean$java_lang_String")) {
                this.__MunregisterWorkCleanerMBean$java_lang_String = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("saveConfig")) {
                this.__MsaveConfig = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

