/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedService;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.ServiceReference;

public class ProvidedServiceDescription {
    public static final int UNREGISTERED = 0;
    public static final int REGISTERED = 1;
    private ProvidedService m_ps;

    public ProvidedServiceDescription(ProvidedService ps) {
        this.m_ps = ps;
    }

    public String[] getServiceSpecifications() {
        return this.m_ps.getServiceSpecifications();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Property[] ps = this.m_ps.getProperties();
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i].getValue() == Property.NO_VALUE) continue;
            props.put(ps[i].getName(), ps[i].getValue());
        }
        return props;
    }

    public void addProperties(Dictionary props) {
        this.m_ps.addProperties(props);
    }

    public void removeProperties(Dictionary props) {
        this.m_ps.deleteProperties(props);
    }

    public int getState() {
        return this.m_ps.getState();
    }

    public String getController() {
        if (this.m_ps.getController() == null) {
            return null;
        }
        return String.valueOf(this.m_ps.getController().getValue());
    }

    public ServiceReference getServiceReference() {
        return this.m_ps.getServiceReference();
    }

    public Object getService() {
        Object[] objs = this.m_ps.getInstanceManager().getPojoObjects();
        if (objs == null) {
            return null;
        }
        return objs[0];
    }

    public Object[] getServices() {
        return this.m_ps.getInstanceManager().getPojoObjects();
    }
}

