/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.model.ThreadPoolProfileDefinition;

public final class ThreadPoolBuilder {
    private final CamelContext camelContext;
    private ThreadPoolProfileDefinition threadPoolDefinition;

    public ThreadPoolBuilder(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.threadPoolDefinition = new ThreadPoolProfileDefinition(camelContext.getExecutorServiceStrategy().getDefaultThreadPoolProfile());
    }

    public ThreadPoolBuilder poolSize(int poolSize) {
        this.threadPoolDefinition.poolSize(poolSize);
        return this;
    }

    public ThreadPoolBuilder maxPoolSize(int maxPoolSize) {
        this.threadPoolDefinition.maxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        this.threadPoolDefinition.keepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        this.threadPoolDefinition.timeUnit(timeUnit);
        return this;
    }

    public ThreadPoolBuilder maxQueueSize(int maxQueueSize) {
        this.threadPoolDefinition.maxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadPoolBuilder rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.threadPoolDefinition.rejectedPolicy(rejectedPolicy);
        return this;
    }

    public ExecutorService build(String name) {
        return this.build(null, name);
    }

    public ExecutorService build(Object source, String name) {
        ExecutorService answer = this.camelContext.getExecutorServiceStrategy().newThreadPool(source, name, this.threadPoolDefinition.getPoolSize(), this.threadPoolDefinition.getMaxPoolSize(), this.threadPoolDefinition.getKeepAliveTime(), this.threadPoolDefinition.getTimeUnit(), this.threadPoolDefinition.getMaxQueueSize(), this.threadPoolDefinition.getRejectedExecutionHandler(), false);
        return answer;
    }
}

