/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.ThreadPoolProfileSupport;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutorServiceStrategy
extends ServiceSupport
implements ExecutorServiceStrategy {
    private static final Log LOG = LogFactory.getLog(DefaultExecutorServiceStrategy.class);
    private final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private final CamelContext camelContext;
    private String threadNamePattern = "Camel Thread ${counter} - ${name}";
    private String defaultThreadPoolProfileId;
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new HashMap<String, ThreadPoolProfile>();

    public DefaultExecutorServiceStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.defaultThreadPoolProfileId = "defaultThreadPoolProfile";
        ThreadPoolProfileSupport defaultProfile = new ThreadPoolProfileSupport(this.defaultThreadPoolProfileId);
        defaultProfile.setDefaultProfile(true);
        defaultProfile.setPoolSize(10);
        defaultProfile.setMaxPoolSize(20);
        defaultProfile.setKeepAliveTime(60L);
        defaultProfile.setTimeUnit(TimeUnit.SECONDS);
        defaultProfile.setMaxQueueSize(1000);
        defaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(defaultProfile);
    }

    @Override
    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    @Override
    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    @Override
    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        ThreadPoolProfile oldProfile = this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        if (oldProfile != null) {
            oldProfile.setDefaultProfile(false);
            if (defaultThreadPoolProfile.getKeepAliveTime() == null) {
                defaultThreadPoolProfile.setKeepAliveTime(oldProfile.getKeepAliveTime());
            }
            if (defaultThreadPoolProfile.getMaxPoolSize() == null) {
                defaultThreadPoolProfile.setMaxPoolSize(oldProfile.getMaxPoolSize());
            }
            if (defaultThreadPoolProfile.getRejectedPolicy() == null) {
                defaultThreadPoolProfile.setRejectedPolicy(oldProfile.getRejectedPolicy());
            }
            if (defaultThreadPoolProfile.getMaxQueueSize() == null) {
                defaultThreadPoolProfile.setMaxQueueSize(oldProfile.getMaxQueueSize());
            }
            if (defaultThreadPoolProfile.getPoolSize() == null) {
                defaultThreadPoolProfile.setPoolSize(oldProfile.getPoolSize());
            }
            if (defaultThreadPoolProfile.getTimeUnit() == null) {
                defaultThreadPoolProfile.setTimeUnit(oldProfile.getTimeUnit());
            }
        }
        ObjectHelper.notEmpty(defaultThreadPoolProfile.getId(), "id", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getKeepAliveTime(), "keepAliveTime", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getMaxPoolSize(), "maxPoolSize", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getMaxQueueSize(), "maxQueueSize", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getPoolSize(), "poolSize", defaultThreadPoolProfile);
        ObjectHelper.notNull((Object)defaultThreadPoolProfile.getTimeUnit(), "timeUnit", defaultThreadPoolProfile);
        LOG.info((Object)("Using custom DefaultThreadPoolProfile: " + defaultThreadPoolProfile));
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(true);
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    @Override
    public String getThreadName(String name) {
        return ExecutorServiceHelper.getThreadName(this.threadNamePattern, name);
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    @Override
    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    @Override
    public ExecutorService lookup(Object source, String name, String executorServiceRef) {
        ExecutorService answer = this.camelContext.getRegistry().lookup(executorServiceRef, ExecutorService.class);
        if (answer != null && LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking up ExecutorService with ref: " + executorServiceRef + " and found it from Registry: " + answer));
        }
        if (answer == null && (answer = this.newThreadPool(source, name, executorServiceRef)) != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking up ExecutorService with ref: " + executorServiceRef + " and found a matching ThreadPoolProfile to create the ExecutorService: " + answer));
        }
        return answer;
    }

    @Override
    public ExecutorService newDefaultThreadPool(Object source, String name) {
        ThreadPoolProfile profile = this.getDefaultThreadPoolProfile();
        ObjectHelper.notNull(profile, "DefaultThreadPoolProfile");
        return this.newThreadPool(source, name, profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getTimeUnit(), profile.getMaxQueueSize(), profile.getRejectedExecutionHandler(), false);
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, String threadPoolProfileId) {
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        ThreadPoolProfile profile = this.getThreadPoolProfile(threadPoolProfileId);
        if (profile != null) {
            Integer poolSize = profile.getPoolSize() != null ? profile.getPoolSize() : defaultProfile.getPoolSize();
            Integer maxPoolSize = profile.getMaxPoolSize() != null ? profile.getMaxPoolSize() : defaultProfile.getMaxPoolSize();
            Long keepAliveTime = profile.getKeepAliveTime() != null ? profile.getKeepAliveTime() : defaultProfile.getKeepAliveTime();
            TimeUnit timeUnit = profile.getTimeUnit() != null ? profile.getTimeUnit() : defaultProfile.getTimeUnit();
            Integer maxQueueSize = profile.getMaxQueueSize() != null ? profile.getMaxQueueSize() : defaultProfile.getMaxQueueSize();
            RejectedExecutionHandler handler = profile.getRejectedExecutionHandler() != null ? profile.getRejectedExecutionHandler() : defaultProfile.getRejectedExecutionHandler();
            return this.newThreadPool(source, name, poolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, handler, false);
        }
        return null;
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source, String name) {
        ExecutorService answer = ExecutorServiceHelper.newCachedThreadPool(this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new cached thread pool for source: " + source + " with name: " + name + ". -> " + answer));
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize) {
        ScheduledExecutorService answer = ExecutorServiceHelper.newScheduledThreadPool(poolSize, this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new scheduled thread pool for source: " + source + " with name: " + name + ". [poolSize=" + poolSize + "]. -> " + answer));
        }
        return answer;
    }

    @Override
    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        ExecutorService answer = ExecutorServiceHelper.newFixedThreadPool(poolSize, this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new fixed thread pool for source: " + source + " with name: " + name + ". [poolSize=" + poolSize + "]. -> " + answer));
        }
        return answer;
    }

    @Override
    public ExecutorService newSingleThreadExecutor(Object source, String name) {
        ExecutorService answer = ExecutorServiceHelper.newSingleThreadExecutor(this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new single thread pool for source: " + source + " with name: " + name + ". -> " + answer));
        }
        return answer;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int corePoolSize, int maxPoolSize) {
        ExecutorService answer = ExecutorServiceHelper.newThreadPool(this.threadNamePattern, name, corePoolSize, maxPoolSize);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new thread pool for source: " + source + " with name: " + name + ". [poolSize=" + corePoolSize + ", maxPoolSize=" + maxPoolSize + "] -> " + answer));
        }
        return answer;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, boolean daemon) {
        ObjectHelper.notNull(name, "ThreadName");
        ExecutorService answer = ExecutorServiceHelper.newThreadPool(this.threadNamePattern, name, corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, rejectedExecutionHandler, daemon);
        this.onThreadPoolCreated(answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new thread pool for source: " + source + " with name: " + name + ". [poolSize=" + corePoolSize + ", maxPoolSize=" + maxPoolSize + ", keepAliveTime=" + keepAliveTime + " " + (Object)((Object)timeUnit) + ", maxQueueSize=" + maxQueueSize + ", rejectedExecutionHandler=" + rejectedExecutionHandler + ", daemon=" + daemon + "] -> " + answer));
        }
        return answer;
    }

    @Override
    public void shutdown(ExecutorService executorService) {
        ObjectHelper.notNull(executorService, "executorService");
        if (executorService.isShutdown()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutdown ExecutorService: " + executorService));
        }
        executorService.shutdown();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Shutdown ExecutorService: " + executorService + " complete."));
        }
    }

    @Override
    public List<Runnable> shutdownNow(ExecutorService executorService) {
        ObjectHelper.notNull(executorService, "executorService");
        if (executorService.isShutdown()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ShutdownNow ExecutorService: " + executorService));
        }
        List<Runnable> answer = executorService.shutdownNow();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ShutdownNow ExecutorService: " + executorService + " complete."));
        }
        return answer;
    }

    private void onThreadPoolCreated(ExecutorService executorService) {
        this.executorServices.add(executorService);
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)executorService;
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool);
            }
        }
        this.onNewExecutorService(executorService);
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        for (ExecutorService executorService : this.executorServices) {
            try {
                this.shutdownNow(executorService);
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error occurred during shutdown of ExecutorService: " + executorService + ". This exception will be ignored."), e);
            }
        }
        this.executorServices.clear();
        this.threadPoolProfiles.clear();
    }
}

