/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsProcessor
extends DelegateProcessor
implements Processor {
    protected final CamelContext camelContext;
    protected final ExecutorService executorService;
    protected WaitForTaskToComplete waitForTaskToComplete;

    public ThreadsProcessor(CamelContext camelContext, Processor output, ExecutorService executorService, WaitForTaskToComplete waitForTaskToComplete) {
        super(output);
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.executorService = executorService;
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Processor output = this.getProcessor();
        if (output == null) {
            return;
        }
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, true);
        Callable<Exchange> task = this.createTask(output, copy);
        Future<Exchange> future = this.executorService.submit(task);
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always) {
            Exchange response = future.get();
            ExchangeHelper.copyResults(exchange, response);
        } else if (wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable(exchange)) {
            Exchange response = future.get();
            ExchangeHelper.copyResults(exchange, response);
        } else {
            exchange.getOut().setBody(future);
        }
    }

    protected Callable<Exchange> createTask(final Processor output, final Exchange copy) {
        return new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                output.process(copy);
                return copy;
            }
        };
    }

    @Override
    public String toString() {
        return "Threads";
    }
}

