/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class UseOriginalAggregationStrategy
implements AggregationStrategy {
    private final ThreadLocal<Exchange> original = new ThreadLocal();
    private final boolean propagateException;

    public UseOriginalAggregationStrategy(boolean propagateException) {
        this.propagateException = propagateException;
    }

    public void setOriginal(Exchange exchange) {
        if (exchange == null) {
            this.original.remove();
        } else {
            this.original.set(exchange);
        }
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exception exception;
        Exchange answer = this.original.get();
        if (answer == null) {
            throw new IllegalStateException("Original Exchange has not been set");
        }
        if (this.propagateException && (exception = this.checkException(oldExchange, newExchange)) != null) {
            answer.setException(exception);
        }
        return answer;
    }

    protected Exception checkException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange.getException();
        }
        return newExchange != null && newExchange.getException() != null ? newExchange.getException() : oldExchange.getException();
    }

    public String toString() {
        return "UseOriginalAggregationStrategy";
    }
}

