/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.transaction.interceptors.AbsTransactionInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CMTNeverTransactionInterceptor
extends AbsTransactionInterceptor {
    private Log logger = LogFactory.getLog(CMTNeverTransactionInterceptor.class);

    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Transaction transaction;
        this.logger.debug((Object)"Calling Never TX interceptor", new Object[0]);
        try {
            transaction = this.getTransactionManager().getTransaction();
        }
        catch (SystemException se) {
            throw new EJBException("Cannot get the current transaction on transaction manager.", (Exception)((Object)se));
        }
        this.logger.debug((Object)"Transaction found = {0}", new Object[]{transaction});
        if (transaction != null) {
            this.logger.warn((Object)"Mandatory as transaction attribute but within a transaction.", new Object[0]);
            throw new EJBException("Client should not call within a transaction context by using NEVER mode.");
        }
        try {
            return invocationContext.proceed();
        }
        catch (Exception e) {
            this.handleUnspecifiedTransactionContext(invocationContext, e);
            return null;
        }
    }
}

