/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.PullPushAdapter;

public class PullPushTestMux
implements MessageListener {
    private Channel channel;
    private PullPushAdapter adapter;
    MyListener[] listeners = null;

    public void receive(Message msg) {
        System.out.println("Main receiver: received msg: " + msg);
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void start() throws Exception {
        int c;
        this.channel = new JChannel();
        this.channel.connect("PullPushTestMux");
        this.adapter = new PullPushAdapter(this.channel);
        this.adapter.setListener(this);
        this.listeners = new MyListener[10];
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = new MyListener(i, this.adapter);
        }
        while ((c = this.choice()) != 113) {
            if ((c -= 48) < 0 || c > 9) {
                System.err.println("Choose between 0 and 9");
                continue;
            }
            if (c == 0) {
                this.adapter.send(new Message(null, null, (Serializable)((Object)"Message from default message listener")));
                continue;
            }
            this.listeners[c].sendMessage();
        }
        this.channel.close();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int choice() {
        int c;
        block9: {
            System.out.println("\n[q]uit [0]: send message on default channel [1-9] send message on other channels:");
            System.out.flush();
            c = System.in.read();
            Object var5_2 = null;
            try {
                System.in.skip(System.in.available());
            }
            catch (Exception ex2) {}
            break block9;
            {
                catch (Exception ex) {
                    int n = -1;
                    Object var5_3 = null;
                    try {
                        System.in.skip(System.in.available());
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    System.in.skip(System.in.available());
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return c;
    }

    public static void main(String[] args) {
        PullPushTestMux t = new PullPushTestMux();
        try {
            t.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public class MyListener
    implements MessageListener {
        Integer id = null;
        PullPushAdapter ad = null;

        MyListener(int id, PullPushAdapter ad) {
            this.id = new Integer(id);
            this.ad = ad;
            ad.registerListener(this.id, this);
        }

        public void receive(Message msg) {
            System.out.println("MyListener #" + this.id + ": received message from " + msg.getSrc() + ": " + msg.getObject());
        }

        public byte[] getState() {
            return null;
        }

        public void setState(byte[] state) {
        }

        void sendMessage() throws Exception {
            Message msg = new Message(null, null, (Serializable)((Object)("Message from " + this.id)));
            this.ad.send(this.id, msg);
        }
    }
}

