/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiClassResolver
extends DefaultClassResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiClassResolver.class);
    public BundleContext bundleContext;

    public OsgiClassResolver(BundleContext context) {
        this.bundleContext = context;
    }

    public Class<?> resolveClass(String name) {
        return this.loadClass(name, (ClassLoader)BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundleContext.getBundle()));
    }

    public <T> Class<T> resolveClass(String name, Class<T> type) {
        Class answer = CastUtils.cast(this.loadClass(name, (ClassLoader)BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundleContext.getBundle())));
        return answer;
    }

    public InputStream loadResourceAsStream(String uri) {
        ObjectHelper.notEmpty((String)uri, (String)"uri");
        URL url = this.loadResourceAsURL(uri);
        InputStream answer = null;
        if (url != null) {
            try {
                answer = url.openStream();
            }
            catch (IOException ex) {
                LOG.error((Object)("Cannot load resource: " + uri), (Throwable)ex);
            }
        }
        return answer;
    }

    public URL loadResourceAsURL(String uri) {
        Bundle bundle;
        ObjectHelper.notEmpty((String)uri, (String)"uri");
        URL url = null;
        Bundle[] arr$ = this.bundleContext.getBundles();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (url = (bundle = arr$[i$]).getEntry(uri)) == null; ++i$) {
        }
        return url;
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        Class answer;
        block7: {
            ObjectHelper.notEmpty((String)name, (String)"name");
            answer = null;
            if (loader != null) {
                try {
                    answer = loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("Cannot load class: " + name + " using classloader: " + loader), (Throwable)e);
                }
            }
        }
        if (answer == null) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                try {
                    answer = bundle.loadClass(name);
                    if (answer == null) continue;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return answer;
    }
}

