/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.io.Serializable;
import java.util.List;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.SliceImplHelper;
import org.apache.openjpa.util.InternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliceInfo
implements Serializable {
    private final boolean _isReplicated;
    private String[] _slices;
    private static transient Localizer _loc = Localizer.forPackage(SliceInfo.class);

    public SliceInfo(boolean replicated, String[] slices) {
        if (slices == null || slices.length == 0) {
            throw new InternalException();
        }
        this._isReplicated = replicated;
        this._slices = slices;
    }

    public SliceInfo(boolean replicated, List<String> slices) {
        if (slices == null || slices.isEmpty()) {
            throw new InternalException();
        }
        this._isReplicated = replicated;
        this._slices = slices.toArray(new String[slices.size()]);
    }

    public SliceInfo(String slice) {
        this(false, new String[]{slice});
    }

    public SliceInfo(String[] slices) {
        this(true, slices);
    }

    public SliceInfo(List<String> slices) {
        this(true, slices);
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public String[] getSlices() {
        return this._slices;
    }

    public SliceInfo setInto(OpenJPAStateManager sm) {
        if (sm == null) {
            throw new NullPointerException();
        }
        if (SliceImplHelper.isReplicated(sm) != this.isReplicated()) {
            throw new InternalException();
        }
        Object previous = sm.setImplData(this, true);
        if (previous == null || previous instanceof SliceInfo) {
            return (SliceInfo)previous;
        }
        throw new InternalException(_loc.get("unknown-impl-data", previous, previous.getClass().getName(), sm.getPersistenceCapable()).getMessage());
    }
}

