/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.TransactionRolledBackException;
import org.objectweb.joram.client.jms.BytesMessage;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.MapMessage;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.MessageAcks;
import org.objectweb.joram.client.jms.MessageConsumer;
import org.objectweb.joram.client.jms.MessageConsumerListener;
import org.objectweb.joram.client.jms.MessageInterceptor;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.ObjectMessage;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.QueueBrowser;
import org.objectweb.joram.client.jms.SingleSessionConsumer;
import org.objectweb.joram.client.jms.StreamMessage;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.client.jms.TextMessage;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.TopicSubscriber;
import org.objectweb.joram.client.jms.XAConnection;
import org.objectweb.joram.client.jms.XAQueueConnection;
import org.objectweb.joram.client.jms.XATopicConnection;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.client.jms.connection.Requestor;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerDenyRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.client.GetAdminTopicReply;
import org.objectweb.joram.shared.client.GetAdminTopicRequest;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.SessCreateTDReply;
import org.objectweb.joram.shared.client.SessCreateTQRequest;
import org.objectweb.joram.shared.client.SessCreateTTRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Session
implements javax.jms.Session {
    public static Logger logger = Debug.getLogger(Session.class.getName());
    private SessionCloseTask closingTask;
    private boolean scheduled;
    protected MessageListener messageListener;
    private String ident;
    private Connection cnx;
    boolean transacted;
    private int acknowledgeMode;
    private boolean autoAck;
    private Vector consumers;
    private Vector producers;
    private Vector browsers;
    private fr.dyade.aaa.common.Queue repliesIn;
    private SessionDaemon daemon;
    private int listenerCount;
    Hashtable sendings;
    Hashtable deliveries;
    private RequestMultiplexer mtpx;
    private Requestor requestor;
    private Requestor receiveRequestor;
    private boolean recover;
    private int status;
    private int sessionMode;
    private int requestStatus;
    private MessageConsumer pendingMessageConsumer;
    private Thread singleThreadOfControl;
    private Closer closer;
    private boolean implicitAck;
    private boolean asyncSend;
    private int queueMessageReadMax;
    private int topicAckBufferMax;
    private int topicPassivationThreshold;
    private int topicActivationThreshold;
    private boolean asyncSub = false;
    private MessageConsumerListener messageConsumerListener;
    private List inInterceptors;
    private List outInterceptors;

    public boolean isImplicitAck() {
        return this.implicitAck;
    }

    public void setImplicitAck(boolean implicitAck) {
        this.implicitAck = implicitAck;
    }

    public boolean isAsyncSend() {
        return this.asyncSend;
    }

    public void setAsyncSend(boolean asyncSend) {
        this.asyncSend = asyncSend;
    }

    public final int getQueueMessageReadMax() {
        return this.queueMessageReadMax;
    }

    public void setQueueMessageReadMax(int queueMessageReadMax) {
        this.queueMessageReadMax = queueMessageReadMax;
    }

    public final int getTopicAckBufferMax() {
        return this.topicAckBufferMax;
    }

    public void setTopicAckBufferMax(int topicAckBufferMax) {
        this.topicAckBufferMax = topicAckBufferMax;
    }

    public final int getTopicPassivationThreshold() {
        return this.topicPassivationThreshold;
    }

    public void setTopicPassivationThreshold(int topicPassivationThreshold) {
        this.topicPassivationThreshold = topicPassivationThreshold;
    }

    public final int getTopicActivationThreshold() {
        return this.topicActivationThreshold;
    }

    public void setTopicActivationThreshold(int topicActivationThreshold) {
        this.topicActivationThreshold = topicActivationThreshold;
    }

    public boolean isAsyncSub() {
        return this.asyncSub;
    }

    public void setAsyncSub(boolean asyncSub) {
        this.asyncSub = asyncSub;
    }

    public void setInMessageInterceptors(List pInInterceptors) {
        this.inInterceptors = pInInterceptors;
    }

    public void setOutMessageInterceptors(List pOutInterceptors) {
        this.outInterceptors = pOutInterceptors;
    }

    Session(Connection cnx, boolean transacted, int acknowledgeMode, RequestMultiplexer mtpx) throws JMSException {
        if (!(transacted || acknowledgeMode == 1 || acknowledgeMode == 2 || acknowledgeMode == 3 || cnx instanceof XAQueueConnection || cnx instanceof XATopicConnection || cnx instanceof XAConnection)) {
            throw new JMSException("Can't create a non transacted session with an invalid acknowledge mode.");
        }
        this.ident = cnx.nextSessionId();
        this.cnx = cnx;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.mtpx = mtpx;
        this.requestor = new Requestor(mtpx);
        this.receiveRequestor = new Requestor(mtpx);
        this.autoAck = !transacted && acknowledgeMode != 2;
        this.consumers = new Vector();
        this.producers = new Vector();
        this.browsers = new Vector();
        this.repliesIn = new fr.dyade.aaa.common.Queue();
        this.sendings = new Hashtable();
        this.deliveries = new Hashtable();
        this.closer = new Closer();
        if (transacted && cnx.getTxPendingTimer() > 0L) {
            this.closingTask = new SessionCloseTask(cnx.getTxPendingTimer() * 1000L);
        }
        this.implicitAck = cnx.getImplicitAck();
        this.asyncSend = cnx.getAsyncSend();
        this.queueMessageReadMax = cnx.getQueueMessageReadMax();
        this.topicAckBufferMax = cnx.getTopicAckBufferMax();
        this.topicActivationThreshold = cnx.getTopicActivationThreshold();
        this.topicPassivationThreshold = cnx.getTopicPassivationThreshold();
        this.setStatus(0);
        this.setSessionMode(0);
        this.setRequestStatus(0);
        this.inInterceptors = cnx.getInInterceptors();
        this.outInterceptors = cnx.getOutInterceptors();
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    boolean isStarted() {
        return this.status == 1;
    }

    private void setSessionMode(int sessionMode) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.setSessionMode(" + SessionMode.toString(sessionMode) + ')'));
        }
        this.sessionMode = sessionMode;
    }

    private void setRequestStatus(int requestStatus) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.setRequestStatus(" + RequestStatus.toString(requestStatus) + ')'));
        }
        this.requestStatus = requestStatus;
    }

    protected synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 2) {
            throw new IllegalStateException("Forbidden call on a closed session.");
        }
    }

    private synchronized void checkThreadOfControl() throws IllegalStateException {
        if (this.singleThreadOfControl != null && Thread.currentThread() != this.singleThreadOfControl) {
            throw new IllegalStateException("Illegal control thread");
        }
    }

    private void checkSessionMode(int expectedSessionMode) throws IllegalStateException {
        if (this.sessionMode == 0) {
            this.setSessionMode(this.sessionMode);
        } else if (this.sessionMode != expectedSessionMode) {
            throw new IllegalStateException("Bad session mode");
        }
    }

    public String toString() {
        return "Sess:" + this.ident;
    }

    public final int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.getAckMode();
    }

    int getAckMode() {
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public final synchronized boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public void setTransacted(boolean t) {
        if (this.status != 2) {
            this.transacted = t;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.setTransacted transacted = " + this.transacted + ", autoAck = " + this.autoAck));
        }
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkSessionMode(3);
        this.messageListener = messageListener;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    public synchronized javax.jms.Message createMessage() throws JMSException {
        this.checkClosed();
        return new Message();
    }

    public synchronized javax.jms.TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new TextMessage();
    }

    public synchronized javax.jms.TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        TextMessage message = new TextMessage();
        message.setText(text);
        return message;
    }

    public synchronized javax.jms.BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new BytesMessage();
    }

    public synchronized javax.jms.MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new MapMessage();
    }

    public synchronized javax.jms.ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ObjectMessage();
    }

    public synchronized javax.jms.ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        this.checkClosed();
        ObjectMessage message = new ObjectMessage();
        message.setObject(obj);
        return message;
    }

    public synchronized javax.jms.StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new StreamMessage();
    }

    public synchronized javax.jms.QueueBrowser createBrowser(javax.jms.Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        QueueBrowser qb = new QueueBrowser(this, (Queue)queue, selector);
        this.browsers.addElement(qb);
        return qb;
    }

    public synchronized javax.jms.QueueBrowser createBrowser(javax.jms.Queue queue) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        QueueBrowser qb = new QueueBrowser(this, (Queue)queue, null);
        this.browsers.addElement(qb);
        return qb;
    }

    public synchronized javax.jms.MessageProducer createProducer(javax.jms.Destination dest) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageProducer mp = new MessageProducer(this, (Destination)dest);
        this.addProducer(mp);
        return mp;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, selector, null, noLocal);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest, String selector) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, selector);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, null);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.createDurableSubscriber(" + topic + ',' + name + ',' + selector + ',' + noLocal + ')'));
        }
        this.checkClosed();
        this.checkThreadOfControl();
        TopicSubscriber ts = new TopicSubscriber(this, (Topic)topic, name, selector, noLocal);
        this.addConsumer(ts);
        return ts;
    }

    public synchronized javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.createDurableSubscriber(" + topic + ',' + name + ')'));
        }
        this.checkClosed();
        this.checkThreadOfControl();
        TopicSubscriber ts = new TopicSubscriber(this, (Topic)topic, name, null, false);
        this.addConsumer(ts);
        return ts;
    }

    public synchronized javax.jms.Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        return new Queue(queueName);
    }

    public synchronized javax.jms.Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        if (topicName.equals("#AdminTopic")) {
            try {
                GetAdminTopicReply reply = (GetAdminTopicReply)this.requestor.request(new GetAdminTopicRequest());
                if (reply.getId() != null) {
                    return new Topic(reply.getId());
                }
                throw new JMSException("AdminTopic could not be retrieved.");
            }
            catch (JMSException exc) {
                throw exc;
            }
            catch (Exception exc) {
                throw new JMSException("AdminTopic could not be retrieved: " + exc);
            }
        }
        return new Topic(topicName);
    }

    public synchronized javax.jms.TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        SessCreateTDReply reply = (SessCreateTDReply)this.requestor.request(new SessCreateTQRequest());
        String tempDest = reply.getAgentId();
        return new TemporaryQueue(tempDest, this.cnx);
    }

    public synchronized javax.jms.TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        SessCreateTDReply reply = (SessCreateTDReply)this.requestor.request(new SessCreateTTRequest());
        String tempDest = reply.getAgentId();
        return new TemporaryTopic(tempDest, this.cnx);
    }

    public synchronized void run() {
        block4: {
            int load = this.repliesIn.size();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("-- " + this + ": loaded with " + load + " message(s) and started."));
            }
            try {
                for (int i = 0; i < load; ++i) {
                    org.objectweb.joram.shared.messages.Message momMsg = (org.objectweb.joram.shared.messages.Message)this.repliesIn.pop();
                    this.onMessage(momMsg, this.messageConsumerListener);
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block4;
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
        }
    }

    void setMessageConsumerListener(MessageConsumerListener mcl) {
        this.messageConsumerListener = mcl;
    }

    public synchronized void commit() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.commit()");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (!this.transacted) {
            throw new IllegalStateException("Can't commit a non transacted session.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": committing..."));
        }
        if (this.scheduled) {
            this.closingTask.cancel();
            this.scheduled = false;
        }
        try {
            CommitRequest commitReq = new CommitRequest();
            Enumeration producerMessages = this.sendings.elements();
            while (producerMessages.hasMoreElements()) {
                ProducerMessages pM = (ProducerMessages)producerMessages.nextElement();
                commitReq.addProducerMessages(pM);
            }
            this.sendings.clear();
            Enumeration targets = this.deliveries.keys();
            while (targets.hasMoreElements()) {
                String target = (String)targets.nextElement();
                MessageAcks acks = (MessageAcks)this.deliveries.get(target);
                commitReq.addAckRequest(new SessAckRequest(target, acks.getIds(), acks.getQueueMode()));
            }
            this.deliveries.clear();
            if (this.asyncSend) {
                commitReq.setAsyncSend(true);
                this.mtpx.sendRequest(commitReq);
            } else {
                this.requestor.request(commitReq);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ": committed."));
            }
        }
        catch (JMSException jE) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)jE);
            }
            TransactionRolledBackException tE = new TransactionRolledBackException("A JMSException was thrown during the commit.");
            tE.setLinkedException((Exception)((Object)jE));
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Exception: " + tE));
            }
            this.rollback();
            throw tE;
        }
    }

    public synchronized void rollback() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.rollback()");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (!this.transacted) {
            throw new IllegalStateException("Can't rollback a non transacted session.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": rolling back..."));
        }
        if (this.scheduled) {
            this.closingTask.cancel();
            this.scheduled = false;
        }
        this.deny();
        this.sendings.clear();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": rolled back."));
        }
    }

    public synchronized void recover() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.recover()");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.transacted) {
            throw new IllegalStateException("Can't recover a transacted session.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " recovering..."));
        }
        if (this.daemon != null && this.daemon.isCurrentThread()) {
            this.recover = true;
        } else {
            this.doRecover();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": recovered."));
        }
    }

    private void doRecover() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.doRecover()");
        }
        this.deny();
    }

    public synchronized void unsubscribe(String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.unsubscribe(" + name + ')'));
        }
        if (name == null) {
            throw new JMSException("Bad subscription name: null");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                MessageConsumer cons = (MessageConsumer)this.consumers.get(i);
                if (cons.queueMode || !cons.targetName.equals(name)) continue;
                throw new JMSException("Can't delete durable subscription " + name + " as long as an active subscriber exists.");
            }
        }
        this.syncRequest(new ConsumerUnsubRequest(name));
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.close()");
        }
        this.closer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() throws JMSException {
        Session session = this;
        synchronized (session) {
            if (this.status == 2) {
                return;
            }
        }
        Vector consumersToClose = (Vector)this.consumers.clone();
        this.consumers.clear();
        for (int i = 0; i < consumersToClose.size(); ++i) {
            MessageConsumer mc = (MessageConsumer)consumersToClose.elementAt(i);
            try {
                mc.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        Vector browsersToClose = (Vector)this.browsers.clone();
        this.browsers.clear();
        for (int i = 0; i < browsersToClose.size(); ++i) {
            QueueBrowser qb = (QueueBrowser)browsersToClose.elementAt(i);
            try {
                qb.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        Vector producersToClose = (Vector)this.producers.clone();
        this.producers.clear();
        for (int i = 0; i < producersToClose.size(); ++i) {
            MessageProducer mp = (MessageProducer)producersToClose.elementAt(i);
            try {
                mp.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        this.stop();
        this.receiveRequestor.close();
        if (this.transacted) {
            this.rollback();
        } else {
            this.deny();
        }
        this.cnx.closeSession(this);
        Session session2 = this;
        synchronized (session2) {
            this.setStatus(2);
        }
    }

    synchronized void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.start()");
        }
        if (this.status == 2) {
            return;
        }
        if (this.status == 1) {
            return;
        }
        if (this.listenerCount > 0) {
            this.doStart();
        }
        this.setStatus(1);
    }

    private void doStart() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.doStart()");
        }
        this.repliesIn.start();
        this.daemon = new SessionDaemon();
        this.daemon.setDaemon(false);
        this.daemon.start();
        this.singleThreadOfControl = this.daemon.getThread();
    }

    synchronized void stop() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.stop()");
        }
        if (this.status == 0 || this.status == 2) {
            return;
        }
        this.doStop();
        this.setStatus(0);
    }

    private void doStop() {
        if (this.daemon != null) {
            this.daemon.stop();
            this.daemon = null;
            this.singleThreadOfControl = null;
        }
    }

    private void prepareSend(Destination dest, org.objectweb.joram.shared.messages.Message msg) throws JMSException {
        ProducerMessages pM;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.prepareSend(" + dest + ',' + msg + ')'));
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.scheduled) {
            this.closingTask.cancel();
        }
        if ((pM = (ProducerMessages)this.sendings.get(dest.getName())) == null) {
            pM = new ProducerMessages(dest.getName());
            this.sendings.put(dest.getName(), pM);
        }
        pM.addMessage(msg);
        if (this.scheduled) {
            this.closingTask.start();
        }
    }

    private void prepareAck(String name, String id, boolean queueMode) {
        MessageAcks acks;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.prepareAck(" + name + ',' + id + ',' + queueMode + ')'));
        }
        if (this.scheduled) {
            this.closingTask.cancel();
        }
        if ((acks = (MessageAcks)this.deliveries.get(name)) == null) {
            acks = new MessageAcks(queueMode);
            this.deliveries.put(name, acks);
        }
        acks.addId(id);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> acks = " + acks));
        }
        if (this.closingTask != null) {
            this.scheduled = true;
            this.closingTask.start();
        }
    }

    synchronized void acknowledge() throws JMSException {
        this.checkClosed();
        if (this.transacted || this.acknowledgeMode != 2) {
            return;
        }
        this.doAcknowledge();
    }

    private void doAcknowledge() throws JMSException {
        Enumeration targets = this.deliveries.keys();
        while (targets.hasMoreElements()) {
            String target = (String)targets.nextElement();
            MessageAcks acks = (MessageAcks)this.deliveries.remove(target);
            this.mtpx.sendRequest(new SessAckRequest(target, acks.getIds(), acks.getQueueMode()));
        }
    }

    private void deny() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.deny()");
        }
        Enumeration targets = this.deliveries.keys();
        while (targets.hasMoreElements()) {
            String target = (String)targets.nextElement();
            MessageAcks acks = (MessageAcks)this.deliveries.remove(target);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> acks = " + acks + ')'));
            }
            SessDenyRequest deny = new SessDenyRequest(target, acks.getIds(), acks.getQueueMode());
            if (acks.getQueueMode()) {
                this.requestor.request(deny);
                continue;
            }
            this.mtpx.sendRequest(deny);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    javax.jms.Message receive(long requestTimeToLive, long waitTimeOut, MessageConsumer mc, String targetName, String selector, boolean queueMode) throws JMSException {
        Message msg;
        block21: {
            Iterator it;
            block22: {
                block19: {
                    block20: {
                        Vector msgs;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Session.receive(" + requestTimeToLive + ',' + waitTimeOut + ',' + targetName + ',' + selector + ',' + queueMode + ')'));
                        }
                        this.preReceive(mc);
                        try {
                            ConsumerMessages reply = null;
                            ConsumerReceiveRequest request = new ConsumerReceiveRequest(targetName, selector, requestTimeToLive, queueMode);
                            if (this.implicitAck) {
                                request.setReceiveAck(true);
                            }
                            reply = (ConsumerMessages)this.receiveRequestor.request(request, waitTimeOut);
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)(" -> reply = " + reply));
                            }
                            Session session = this;
                            // MONITORENTER : session
                            if (this.status == 2) {
                                if (reply != null) {
                                    this.mtpx.deny(reply);
                                }
                                javax.jms.Message message = null;
                                // MONITOREXIT : session
                                this.postReceive();
                                return message;
                            }
                            if (reply == null) break block19;
                            msgs = reply.getMessages();
                            if (msgs == null || msgs.isEmpty()) break block20;
                        }
                        catch (Throwable throwable) {
                            this.postReceive();
                            throw throwable;
                        }
                        msg = Message.wrapMomMessage(this, (org.objectweb.joram.shared.messages.Message)msgs.get(0));
                        String msgId = msg.getJMSMessageID();
                        if (this.autoAck && !this.implicitAck) {
                            ConsumerAckRequest req = new ConsumerAckRequest(targetName, queueMode);
                            req.addId(msgId);
                            this.mtpx.sendRequest(req);
                        } else {
                            this.prepareAck(targetName, msgId, queueMode);
                        }
                        msg.session = this;
                        if (this.inInterceptors == null || this.inInterceptors.isEmpty()) break block21;
                        it = this.inInterceptors.iterator();
                        break block22;
                    }
                    javax.jms.Message message = null;
                    // MONITOREXIT : session
                    this.postReceive();
                    return message;
                }
                javax.jms.Message message = null;
                // MONITOREXIT : session
                this.postReceive();
                return message;
            }
            while (it.hasNext()) {
                MessageInterceptor interceptor = (MessageInterceptor)it.next();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Intercepting the message after receiving by " + interceptor.getClass().getName()));
                }
                try {
                    interceptor.handle(msg, this);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(BasicLevel.WARN)) continue;
                    logger.log(BasicLevel.WARN, (Object)"Warning while interception (continue anyway...)", t);
                }
            }
        }
        Message message = msg;
        // MONITOREXIT : session
        this.postReceive();
        return message;
    }

    private synchronized void preReceive(MessageConsumer mc) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.preReceive(" + mc + ')'));
        }
        mc.checkClosed();
        this.checkClosed();
        this.checkThreadOfControl();
        switch (this.sessionMode) {
            case 0: {
                this.setSessionMode(1);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal session mode");
            }
        }
        if (this.requestStatus != 0) {
            throw new IllegalStateException("Illegal request status");
        }
        this.singleThreadOfControl = Thread.currentThread();
        this.pendingMessageConsumer = mc;
        this.setRequestStatus(1);
    }

    private synchronized void postReceive() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Session.postReceive()");
        }
        this.singleThreadOfControl = null;
        this.pendingMessageConsumer = null;
        this.setRequestStatus(0);
        this.setSessionMode(0);
        this.notifyAll();
    }

    protected synchronized void addConsumer(MessageConsumer mc) {
        this.consumers.addElement(mc);
    }

    synchronized void closeConsumer(MessageConsumer mc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.closeConsumer(" + mc + ')'));
        }
        this.consumers.removeElement(mc);
        if (this.pendingMessageConsumer == mc && this.requestStatus == 1) {
            this.receiveRequestor.close();
            try {
                while (this.requestStatus != 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.receiveRequestor = new Requestor(this.mtpx);
        }
    }

    synchronized void checkConsumers(String agentId) throws JMSException {
        for (int j = 0; j < this.consumers.size(); ++j) {
            MessageConsumer cons = (MessageConsumer)this.consumers.elementAt(j);
            if (!agentId.equals(cons.dest.agentId)) continue;
            throw new JMSException("Consumers still exist for this temp queue.");
        }
    }

    protected void addProducer(MessageProducer mp) {
        this.producers.addElement(mp);
    }

    synchronized void closeProducer(MessageProducer mp) {
        this.producers.removeElement(mp);
    }

    synchronized void closeBrowser(QueueBrowser qb) {
        this.browsers.removeElement(qb);
    }

    synchronized MessageConsumerListener addMessageListener(MessageConsumerListener mcl) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.addMessageListener(" + mcl + ')'));
        }
        this.checkClosed();
        this.checkThreadOfControl();
        this.checkSessionMode(2);
        mcl.start();
        if (this.status == 1 && this.listenerCount == 0) {
            this.doStart();
        }
        ++this.listenerCount;
        return mcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessageListener(MessageConsumerListener mcl, boolean check) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.removeMessageListener(" + mcl + ',' + check + ')'));
        }
        if (check) {
            this.checkClosed();
            this.checkThreadOfControl();
        }
        mcl.close();
        Session session = this;
        synchronized (session) {
            --this.listenerCount;
            if (this.status == 1 && this.listenerCount == 0) {
                try {
                    this.repliesIn.stop();
                }
                catch (InterruptedException iE) {
                    // empty catch block
                }
                this.doStop();
            }
        }
    }

    void pushMessages(SingleSessionConsumer consumerListener, ConsumerMessages messages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.pushMessages(" + consumerListener + ',' + messages + ')'));
        }
        this.repliesIn.push(new MessageListenerContext(consumerListener, messages));
    }

    void onMessage(org.objectweb.joram.shared.messages.Message msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.onMessage(" + msg + ')'));
        }
        this.repliesIn.push(msg);
    }

    private void denyMessage(String targetName, String msgId, boolean queueMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.denyMessage(" + targetName + ',' + msgId + ',' + queueMode + ')'));
        }
        ConsumerDenyRequest cdr = new ConsumerDenyRequest(targetName, msgId, queueMode);
        if (queueMode) {
            this.requestor.request(cdr);
        } else {
            this.mtpx.sendRequest(cdr, null);
        }
    }

    private void onMessages(MessageListenerContext ctx) throws JMSException {
        Vector msgs = ctx.messages.getMessages();
        for (int i = 0; i < msgs.size(); ++i) {
            this.onMessage((org.objectweb.joram.shared.messages.Message)msgs.elementAt(i), ctx.consumerListener);
        }
    }

    void onMessage(org.objectweb.joram.shared.messages.Message momMsg, MessageConsumerListener mcl) throws JMSException {
        String msgId = momMsg.id;
        if (!this.autoAck) {
            this.prepareAck(mcl.getTargetName(), msgId, mcl.getQueueMode());
        }
        Message msg = null;
        try {
            msg = Message.wrapMomMessage(this, momMsg);
        }
        catch (JMSException jE) {
            if (this.autoAck) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode());
            }
            return;
        }
        msg.session = this;
        try {
            if (this.messageListener == null) {
                mcl.onMessage(msg, this.acknowledgeMode);
            } else {
                mcl.onMessage(msg, this.messageListener, this.acknowledgeMode);
            }
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            if (this.autoAck || mcl.isClosed()) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode());
            }
            return;
        }
        if (this.recover) {
            if (this.autoAck) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode());
            } else {
                this.doRecover();
                this.recover = false;
            }
        } else if (this.autoAck) {
            mcl.ack(msgId, this.acknowledgeMode);
        }
    }

    synchronized void send(Destination dest, javax.jms.Message msg, int deliveryMode, int priority, long timeToLive, boolean timestampDisabled) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Session.send(" + dest + ',' + msg + ',' + deliveryMode + ',' + priority + ',' + timeToLive + ',' + timestampDisabled + ')'));
        }
        this.checkClosed();
        this.checkThreadOfControl();
        String msgID = this.cnx.nextMessageId();
        msg.setJMSMessageID(msgID);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSDestination((javax.jms.Destination)dest);
        if (timeToLive == 0L) {
            msg.setJMSExpiration(0L);
        } else {
            msg.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        msg.setJMSPriority(priority);
        if (!timestampDisabled) {
            msg.setJMSTimestamp(System.currentTimeMillis());
        }
        Message joramMsg = null;
        try {
            joramMsg = (Message)msg;
        }
        catch (ClassCastException exc) {
            try {
                joramMsg = Message.convertJMSMessage(msg);
            }
            catch (JMSException jE) {
                MessageFormatException mE = new MessageFormatException("Message to send is invalid.");
                mE.setLinkedException((Exception)((Object)jE));
                throw mE;
            }
        }
        if (this.outInterceptors != null && !this.outInterceptors.isEmpty()) {
            for (MessageInterceptor interceptor : this.outInterceptors) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Intercepting the message before sending by " + interceptor.getClass().getName()));
                }
                try {
                    interceptor.handle(joramMsg, this);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(BasicLevel.WARN)) continue;
                    logger.log(BasicLevel.WARN, (Object)"Warning while interception (continue anyway...)", t);
                }
            }
        }
        joramMsg.prepare();
        if (this.transacted) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Buffering the message.");
            }
            this.prepareSend(dest, (org.objectweb.joram.shared.messages.Message)joramMsg.momMsg.clone());
        } else {
            ProducerMessages pM = new ProducerMessages(dest.getName(), (org.objectweb.joram.shared.messages.Message)joramMsg.momMsg.clone());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Sending " + joramMsg));
            }
            if (this.asyncSend || !joramMsg.momMsg.persistent) {
                pM.setAsyncSend(true);
                this.mtpx.sendRequest(pM);
            } else {
                this.requestor.request(pM);
            }
        }
    }

    synchronized AbstractJmsReply syncRequest(AbstractJmsRequest request) throws JMSException {
        return this.requestor.request(request);
    }

    final Connection getConnection() {
        return this.cnx;
    }

    final String getId() {
        return this.ident;
    }

    final RequestMultiplexer getRequestMultiplexer() {
        return this.mtpx;
    }

    public final boolean isAutoAck() {
        return this.autoAck;
    }

    private static class MessageListenerContext {
        SingleSessionConsumer consumerListener;
        ConsumerMessages messages;

        MessageListenerContext(SingleSessionConsumer consumerListener, ConsumerMessages messages) {
            this.consumerListener = consumerListener;
            this.messages = messages;
        }
    }

    private class SessionDaemon
    extends Daemon {
        SessionDaemon() {
            super("Connection#" + Session.this.cnx + " - Session#" + Session.this.ident);
        }

        public void run() {
            while (this.running) {
                MessageListenerContext ctx;
                this.canStop = true;
                try {
                    ctx = (MessageListenerContext)Session.this.repliesIn.get();
                    Session.this.repliesIn.pop();
                }
                catch (InterruptedException exc) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                    }
                    return;
                }
                this.canStop = false;
                try {
                    Session.this.onMessages(ctx);
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
        }

        Thread getThread() {
            return this.thread;
        }

        protected void shutdown() {
        }

        protected void close() {
        }
    }

    private class SessionCloseTask
    extends TimerTask {
        private long txPendingTimer;

        SessionCloseTask(long txPendingTimer) {
            this.txPendingTimer = txPendingTimer;
        }

        public void run() {
            try {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"Session closed because of pending transaction");
                }
                Session.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void start() {
            try {
                Session.this.mtpx.schedule(this, this.txPendingTimer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Closer {
        Closer() {
        }

        synchronized void close() throws JMSException {
            Session.this.doClose();
        }
    }

    private static class RequestStatus {
        public static final int NONE = 0;
        public static final int RUN = 1;
        public static final int DONE = 2;
        private static final String[] names = new String[]{"NONE", "RUN", "DONE"};

        private RequestStatus() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    private static class SessionMode {
        public static final int NONE = 0;
        public static final int RECEIVE = 1;
        public static final int LISTENER = 2;
        public static final int APP_SERVER = 3;
        private static final String[] names = new String[]{"NONE", "RECEIVE", "LISTENER", "APP_SERVER"};

        private SessionMode() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    private static class Status {
        public static final int STOP = 0;
        public static final int START = 1;
        public static final int CLOSE = 2;
        private static final String[] names = new String[]{"STOP", "START", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

