/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaModelInputImpl
implements JavaModelInput {
    private JavaClass[] jClasses;
    private JavaModel jModel;

    public JavaModelInputImpl(Type[] types, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            TypeMappingInfo typeMappingInfo = new TypeMappingInfo();
            Type type = types[i];
            typeMappingInfo.setType(type);
            this.jClasses[i] = this.buildJavaClassImpl(type);
        }
    }

    public JavaModelInputImpl(TypeMappingInfo[] types, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            TypeMappingInfo typeMappingInfo = types[i];
            Type type = typeMappingInfo.getType();
            this.jClasses[i] = this.buildJavaClassImpl(type);
        }
    }

    public JavaModelInputImpl(Class[] classes, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.jClasses[i] = javaModel.getClass(classes[i]);
        }
    }

    private JavaClassImpl buildJavaClassImpl(Type type) {
        if (type instanceof Class) {
            return (JavaClassImpl)this.jModel.getClass((Class)type);
        }
        ParameterizedType pType = (ParameterizedType)type;
        return new JavaClassImpl(pType, (Class)pType.getRawType(), (JavaModelImpl)this.jModel);
    }

    public JavaClass[] getJavaClasses() {
        return this.jClasses;
    }

    public JavaModel getJavaModel() {
        return this.jModel;
    }
}

