/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.HashMap;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class DirectMapChangeRecord
extends DeferrableChangeRecord {
    protected HashMap addObjectsList;
    protected HashMap removeObjectsList;

    public DirectMapChangeRecord() {
    }

    public DirectMapChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public boolean hasChanges() {
        return this.addObjectsList != null && !this.addObjectsList.isEmpty() || this.removeObjectsList != null && !this.removeObjectsList.isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        for (Object key : ((DirectMapChangeRecord)mergeFromRecord).getAddObjects().keySet()) {
            if (this.getAddObjects().containsKey(key)) continue;
            if (this.getRemoveObjects().containsKey(key)) {
                this.getRemoveObjects().remove(key);
                continue;
            }
            this.getAddObjects().put(key, ((DirectMapChangeRecord)mergeFromRecord).getAddObjects().get(key));
        }
        for (Object key : ((DirectMapChangeRecord)mergeFromRecord).getRemoveObjects().keySet()) {
            if (this.getRemoveObjects().containsKey(key)) continue;
            if (this.getAddObjects().containsKey(key)) {
                this.getAddObjects().remove(key);
                continue;
            }
            this.getRemoveObjects().put(key, ((DirectMapChangeRecord)mergeFromRecord).getRemoveObjects().get(key));
        }
    }

    public void addAdditionChange(HashMap additions) {
        if (this.getAddObjects().size() == 0) {
            this.addObjectsList = additions;
            return;
        }
        for (Object key : additions.keySet()) {
            if (this.getAddObjects().containsKey(key)) {
                this.getAddObjects().put(key, additions.get(key));
                continue;
            }
            if (!additions.get(key).equals(this.getAddObjects().get(key))) continue;
            this.getAddObjects().put(key, additions.get(key));
        }
    }

    public void addRemoveChange(HashMap subtractions) {
        if (this.getRemoveObjects().size() == 0) {
            this.removeObjectsList = subtractions;
            return;
        }
        for (Object key : subtractions.keySet()) {
            if (!this.getRemoveObjects().containsKey(key)) {
                this.getRemoveObjects().put(key, subtractions.get(key));
                continue;
            }
            if (!subtractions.get(key).equals(this.getRemoveObjects().get(key))) continue;
            this.getRemoveObjects().put(key, subtractions.get(key));
        }
    }

    public void addAdditionChange(Object key, Object value) {
        if (this.getRemoveObjects().containsKey(key)) {
            if (value.equals(this.getRemoveObjects().get(key))) {
                this.getRemoveObjects().remove(key);
            } else {
                this.getAddObjects().put(key, value);
            }
        } else {
            this.getAddObjects().put(key, value);
        }
    }

    public void addRemoveChange(Object key, Object value) {
        if (this.getAddObjects().containsKey(key)) {
            this.getAddObjects().remove(key);
        } else if (!this.getRemoveObjects().containsKey(key)) {
            this.getRemoveObjects().put(key, value);
        }
    }

    public void setAddObjects(HashMap addObjects) {
        this.addObjectsList = addObjects;
    }

    public HashMap getAddObjects() {
        if (this.addObjectsList == null) {
            this.addObjectsList = new HashMap();
        }
        return this.addObjectsList;
    }

    public void setRemoveObjects(HashMap removeObjects) {
        this.removeObjectsList = removeObjects;
    }

    public HashMap getRemoveObjects() {
        if (this.removeObjectsList == null) {
            this.removeObjectsList = new HashMap();
        }
        return this.removeObjectsList;
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }
}

