/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.openjpa.lib.util.LRUMap;
import org.apache.openjpa.lib.util.SizedMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;

public class CacheMap
implements Map {
    protected final SizedMap cacheMap;
    protected final SizedMap softMap;
    protected final Map pinnedMap;
    private int _pinnedSize = 0;
    private final ReentrantLock _writeLock = new ReentrantLock();
    private final ReentrantLock _readLock;

    public CacheMap() {
        this(false, 1000);
    }

    public CacheMap(boolean lru, int max) {
        this(lru, max, max / 2, 0.75f);
    }

    public CacheMap(boolean lru, int max, int size, float load) {
        this(lru, max, size, load, 16);
    }

    public CacheMap(boolean lru, int max, int size, float load, int concurrencyLevel) {
        if (size < 0) {
            size = 500;
        }
        this.softMap = new ConcurrentReferenceHashMap(0, 2, size, load){

            public void overflowRemoved(Object key, Object value) {
                CacheMap.this.softMapOverflowRemoved(key, value);
            }

            public void valueExpired(Object key) {
                CacheMap.this.softMapValueExpired(key);
            }
        };
        this.pinnedMap = new ConcurrentHashMap();
        if (!lru) {
            this.cacheMap = new ConcurrentHashMap(size, load){

                public void overflowRemoved(Object key, Object value) {
                    CacheMap.this.cacheMapOverflowRemoved(key, value);
                }
            };
            this._readLock = null;
        } else {
            this.cacheMap = new LRUMap(size, load){

                public void overflowRemoved(Object key, Object value) {
                    CacheMap.this.cacheMapOverflowRemoved(key, value);
                }
            };
            this._readLock = this._writeLock;
        }
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        this.cacheMap.setMaxSize(max);
    }

    protected void cacheMapOverflowRemoved(Object key, Object value) {
        if (this.softMap.size() < this.softMap.getMaxSize()) {
            this.put(this.softMap, key, value);
        } else {
            this.entryRemoved(key, value, true);
        }
    }

    protected void softMapOverflowRemoved(Object key, Object value) {
        this.entryRemoved(key, value, true);
    }

    protected void softMapValueExpired(Object key) {
        this.entryRemoved(key, null, true);
    }

    protected Object put(Map map, Object key, Object value) {
        return map.put(key, value);
    }

    protected Object remove(Map map, Object key) {
        return map.remove(key);
    }

    public void readLock() {
        if (this._readLock != null) {
            this._readLock.lock();
        }
    }

    public void readUnlock() {
        if (this._readLock != null) {
            this._readLock.unlock();
        }
    }

    public void writeLock() {
        this._writeLock.lock();
    }

    public void writeUnlock() {
        this._writeLock.unlock();
    }

    public boolean isLRU() {
        return this._readLock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        this.writeLock();
        try {
            this.cacheMap.setMaxSize(size < 0 ? Integer.MAX_VALUE : size);
            Object var3_2 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    public int getCacheSize() {
        int max = this.cacheMap.getMaxSize();
        return max == Integer.MAX_VALUE ? -1 : max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftReferenceSize(int size) {
        this.writeLock();
        try {
            this.softMap.setMaxSize(size < 0 ? Integer.MAX_VALUE : size);
            Object var3_2 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    public int getSoftReferenceSize() {
        int max = this.softMap.getMaxSize();
        return max == Integer.MAX_VALUE ? -1 : max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPinnedKeys() {
        this.readLock();
        try {
            Set set = Collections.unmodifiableSet(this.pinnedMap.keySet());
            Object var3_2 = null;
            this.readUnlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pin(Object key) {
        block6: {
            block5: {
                this.writeLock();
                try {
                    if (!this.pinnedMap.containsKey(key)) break block5;
                    boolean bl = this.pinnedMap.get(key) != null;
                    Object var5_4 = null;
                    this.writeUnlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            Object val = this.remove(this.cacheMap, key);
            if (val == null) {
                val = this.remove(this.softMap, key);
            }
            this.put(this.pinnedMap, key, val);
            if (val == null) break block6;
            ++this._pinnedSize;
            boolean bl = true;
            Object var5_5 = null;
            this.writeUnlock();
            return bl;
        }
        boolean bl = false;
        Object var5_6 = null;
        this.writeUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unpin(Object key) {
        block3: {
            this.writeLock();
            try {
                Object val = this.remove(this.pinnedMap, key);
                if (val == null) break block3;
                this.put(key, val);
                --this._pinnedSize;
                boolean bl = true;
                Object var5_5 = null;
                this.writeUnlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.writeUnlock();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var5_6 = null;
        this.writeUnlock();
        return bl;
    }

    protected void entryRemoved(Object key, Object value, boolean expired) {
    }

    protected void entryAdded(Object key, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object val;
        block4: {
            this.readLock();
            try {
                val = this.pinnedMap.get(key);
                if (val == null) break block4;
                Object v = val;
                Object var5_5 = null;
                this.readUnlock();
                return v;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.readUnlock();
                throw throwable;
            }
        }
        val = this.cacheMap.get(key);
        if (val == null && (val = this.softMap.get(key)) != null) {
            this.put(key, val);
        }
        Object v = val;
        Object var5_6 = null;
        this.readUnlock();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        block11: {
            block10: {
                this.writeLock();
                try {
                    if (!this.pinnedMap.containsKey(key)) break block10;
                    Object val = this.put(this.pinnedMap, key, value);
                    if (val == null) {
                        ++this._pinnedSize;
                        this.entryAdded(key, value);
                    } else {
                        this.entryRemoved(key, val, false);
                        this.entryAdded(key, value);
                    }
                    Object object = val;
                    Object var6_8 = null;
                    this.writeUnlock();
                    return object;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            if (this.cacheMap.getMaxSize() != 0) break block11;
            Object var4_6 = null;
            Object var6_9 = null;
            this.writeUnlock();
            return var4_6;
        }
        Object val = this.put(this.cacheMap, key, value);
        if (val == null) {
            val = this.remove(this.softMap, key);
            if (val == null) {
                this.entryAdded(key, value);
            } else {
                this.entryRemoved(key, val, false);
                this.entryAdded(key, value);
            }
        } else {
            this.entryRemoved(key, val, false);
            this.entryAdded(key, value);
        }
        Object object = val;
        Object var6_10 = null;
        this.writeUnlock();
        return object;
    }

    public void putAll(Map map) {
        this.putAll(map, true);
    }

    public void putAll(Map map, boolean replaceExisting) {
        for (Map.Entry entry : map.entrySet()) {
            if (!replaceExisting && this.containsKey(entry.getKey())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        block6: {
            this.writeLock();
            try {
                if (!this.pinnedMap.containsKey(key)) break block6;
                Object val = this.put(this.pinnedMap, key, null);
                if (val != null) {
                    --this._pinnedSize;
                    this.entryRemoved(key, val, false);
                }
                Object object = val;
                Object var5_6 = null;
                this.writeUnlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.writeUnlock();
                throw throwable;
            }
        }
        Object val = this.remove(this.cacheMap, key);
        if (val == null) {
            val = this.softMap.remove(key);
        }
        if (val != null) {
            this.entryRemoved(key, val, false);
        }
        Object object = val;
        Object var5_7 = null;
        this.writeUnlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock();
        try {
            this.notifyEntryRemovals(this.pinnedMap.entrySet());
            this.pinnedMap.clear();
            this._pinnedSize = 0;
            this.notifyEntryRemovals(this.cacheMap.entrySet());
            this.cacheMap.clear();
            this.notifyEntryRemovals(this.softMap.entrySet());
            this.softMap.clear();
            Object var2_1 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    private void notifyEntryRemovals(Set set) {
        for (Map.Entry entry : set) {
            if (entry.getValue() == null) continue;
            this.entryRemoved(entry.getKey(), entry.getValue(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.readLock();
        try {
            int n = this._pinnedSize + this.cacheMap.size() + this.softMap.size();
            Object var3_2 = null;
            this.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.readLock();
        try {
            boolean bl = this.pinnedMap.get(key) != null || this.cacheMap.containsKey(key) || this.softMap.containsKey(key);
            Object var4_3 = null;
            this.readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object val) {
        this.readLock();
        try {
            boolean bl = this.pinnedMap.containsValue(val) || this.cacheMap.containsValue(val) || this.softMap.containsValue(val);
            Object var4_3 = null;
            this.readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public Set keySet() {
        return new KeySet();
    }

    public Collection values() {
        return new ValueCollection();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock();
        try {
            String string = "CacheMap:" + this.cacheMap.toString() + "::" + this.softMap.toString();
            Object var3_2 = null;
            this.readUnlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    private class EntryIterator
    implements Iterator,
    Predicate {
        public static final int ENTRY = 0;
        public static final int KEY = 1;
        public static final int VALUE = 2;
        private final IteratorChain _itr = new IteratorChain();
        private final int _type;

        public EntryIterator(int type) {
            this._type = type;
            this._itr.addIterator((Iterator)new FilterIterator(this.getView(CacheMap.this.pinnedMap), (Predicate)this));
            this._itr.addIterator(this.getView(CacheMap.this.cacheMap));
            this._itr.addIterator(this.getView(CacheMap.this.softMap));
        }

        private Iterator getView(Map m) {
            if (m == null) {
                return null;
            }
            switch (this._type) {
                case 1: {
                    return m.keySet().iterator();
                }
                case 2: {
                    return m.values().iterator();
                }
            }
            return m.entrySet().iterator();
        }

        public boolean hasNext() {
            return this._itr.hasNext();
        }

        public Object next() {
            return this._itr.next();
        }

        public void remove() {
            this._itr.remove();
        }

        public boolean evaluate(Object obj) {
            switch (this._type) {
                case 0: {
                    return ((Map.Entry)obj).getValue() != null;
                }
                case 2: {
                    return obj != null;
                }
            }
            return true;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public int size() {
            return CacheMap.this.size();
        }

        public Iterator iterator() {
            return new EntryIterator(2);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public int size() {
            return CacheMap.this.size();
        }

        public Iterator iterator() {
            return new EntryIterator(1);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public int size() {
            return CacheMap.this.size();
        }

        public boolean add(Object o) {
            Map.Entry entry = (Map.Entry)o;
            CacheMap.this.put(entry.getKey(), entry.getValue());
            return true;
        }

        public Iterator iterator() {
            return new EntryIterator(0);
        }
    }
}

