/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DateConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.LiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class TemporalLiteralNode
extends LiteralNode {
    private TemporalType type;

    public TemporalLiteralNode(TemporalType type) {
        this.type = type;
    }

    public TemporalLiteralNode(String theString, TemporalType type) {
        this(type);
        this.setLiteral(theString);
    }

    public Expression generateExpression(GenerationContext context) {
        DateConstantExpression whereClause = new DateConstantExpression(this.literal, context.getBaseExpression());
        return whereClause;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.type == TemporalType.DATE) {
            this.setType(typeHelper.getSQLDateType());
        } else if (this.type == TemporalType.TIME) {
            this.setType(typeHelper.getTimeType());
        } else if (this.type == TemporalType.TIMESTAMP) {
            this.setType(typeHelper.getTimestampType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemporalType {
        DATE,
        TIME,
        TIMESTAMP;

    }
}

