/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.BinaryOperator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.ConditionalAnd;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Project;
import org.objectweb.util.monolog.api.BasicLevel;

public class PushSelectionRule
extends BasicRule {
    public PushSelectionRule() {
        super("PushSelectionRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        this.rewriteExp(qt, null);
        return qt;
    }

    protected void rewriteExp(QueryTree qt, Expression addedExp) throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("****(qt=" + qt + ", addedExp=" + addedExp + ")"));
        }
        if (!(qt instanceof QueryLeaf)) {
            addedExp = this.goDownFieldOperand((Expression)addedExp).e;
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("addedExp=" + addedExp));
        }
        FilteredQueryTree fqt = null;
        BasicRule.ModifiedExpression me = null;
        if (qt instanceof FilteredQueryTree && qt.getClass() != Project.class) {
            fqt = (FilteredQueryTree)qt;
            me = this.merge(fqt.getQueryFilter(), addedExp, 1);
            if (qt instanceof QueryLeaf) {
                if (me.isModified) {
                    fqt.setQueryFilter(me.e);
                }
                return;
            }
        } else {
            me = new BasicRule.ModifiedExpression();
            me.e = addedExp;
        }
        HashMap qt2e = new HashMap();
        me = this.extractMapFromExpression(me.e, qt2e, 0);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("me.isModified=" + me.isModified));
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("fqt=" + fqt));
        }
        if (me.isModified && fqt != null) {
            fqt.setQueryFilter(me.e);
        }
        QueryTree[] qts = ((QueryNode)qt).getChildren();
        for (int i = 0; i < qts.length; ++i) {
            this.rewriteExp(qts[i], (Expression)qt2e.get(qts[i]));
        }
    }

    public BasicRule.ModifiedExpression merge(Expression origin, Expression addExp, int op) {
        BasicRule.ModifiedExpression result = new BasicRule.ModifiedExpression();
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Merge(" + origin + ", " + addExp + ", " + op + ")"));
        }
        if (addExp == null) {
            result.e = origin;
            result.isModified = false;
        } else if (origin == null) {
            result.e = addExp;
            result.isModified = true;
        } else {
            result.e = op == 2 ? new ConditionalAnd(origin, addExp) : new And(origin, addExp);
            result.isModified = true;
        }
        return result;
    }

    public BasicRule.ModifiedExpression extractMapFromExpression(Expression e, Map qt2e, int op) throws MedorException {
        BasicRule.ModifiedExpression result = new BasicRule.ModifiedExpression();
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("extractMapFromExpression(" + e + ")"));
        }
        if (e == null) {
            result.e = e;
            result.isModified = false;
        } else if (e instanceof And || e instanceof ConditionalAnd) {
            int curOp = e instanceof And ? 1 : 2;
            BasicRule.ModifiedExpression l = this.extractMapFromExpression(((BinaryOperator)e).getExpression(0), qt2e, curOp);
            BasicRule.ModifiedExpression r = this.extractMapFromExpression(((BinaryOperator)e).getExpression(1), qt2e, curOp);
            if (l.e == null) {
                result.isModified = true;
                result.e = r.e;
            } else if (r.e == null) {
                result.isModified = true;
                result.e = l.e;
            } else {
                result.e = e;
                result.isModified = false;
                if (l.isModified) {
                    ((BinaryOperator)e).setExpression(0, l.e);
                    result.isModified = true;
                }
                if (r.isModified) {
                    ((BinaryOperator)e).setExpression(1, r.e);
                    result.isModified = true;
                    result.e = e;
                }
            }
        } else {
            SameQT sqt = this.isSameQT(e);
            if (sqt.isSame) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("extractMapFromExpression: same QT: sqt.qt=" + sqt.qt));
                }
                BasicRule.ModifiedExpression me = this.merge((Expression)qt2e.get(sqt.qt), e, op);
                qt2e.put(sqt.qt, me.e);
                result.isModified = true;
                result.e = null;
            } else {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)"extractMapFromExpression: not same QT:");
                }
                result.isModified = false;
                result.e = e;
            }
        }
        return result;
    }

    public SameQT isSameQT(Expression e) throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("isSameQT(" + e + ")"));
        }
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            SameQT res = new SameQT();
            res.isSame = true;
            SameQT c = null;
            for (int i = 0; i < op.getOperandNumber() && res.isSame; ++i) {
                c = this.isSameQT(((Operator)e).getExpression(i));
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("isSameQT(): c.isSame=" + c.isSame));
                }
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("isSameQT(): c.qt=" + c.qt));
                }
                res.isSame &= c.isSame;
                if (res.qt == null) {
                    res.qt = c.qt;
                    continue;
                }
                if (c.qt == null) continue;
                res.isSame = res.isSame & c.qt == res.qt;
            }
            return res;
        }
        if (e instanceof FieldOperand) {
            QueryTree qtChild = ((QueryTreeField)((FieldOperand)e).getField()).getQueryTree();
            return new SameQT(true, qtChild);
        }
        return new SameQT(true, null);
    }

    public BasicRule.ModifiedExpression goDownFieldOperand(Expression e) throws MedorException {
        BasicRule.ModifiedExpression me = new BasicRule.ModifiedExpression();
        me.e = e;
        me.isModified = false;
        if (e instanceof Operator) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Operator " + e));
            }
            Operator op = (Operator)e;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                me = this.goDownFieldOperand(op.getExpression(i));
                if (!me.isModified) continue;
                op.setExpression(i, me.e);
            }
            me.e = e;
            me.isModified = false;
        } else if (e instanceof FieldOperand) {
            FieldOperand fo;
            QueryTreeField f;
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("FieldOperand " + e));
            }
            if ((f = (QueryTreeField)(fo = (FieldOperand)e).getField()).getQueryTree() instanceof QueryLeaf) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)"FieldOperand QueryLeaf");
                }
            } else if (f instanceof PropagatedField) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("FieldOperand PropagatedField " + f));
                }
                fo.setField(((PropagatedField)f).getPreviousFields()[0]);
            } else if (f instanceof CalculatedField) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("FieldOperand CalculatedField" + f));
                }
                me.e = ((CalculatedField)((Object)e)).getExpression();
                me.isModified = true;
            } else {
                throw new MedorException("Impossible move other type:" + f);
            }
        }
        return me;
    }

    public class SameQT {
        public boolean isSame;
        public QueryTree qt;

        public SameQT(boolean i, QueryTree q) {
            this.isSame = i;
            this.qt = q;
        }

        public SameQT() {
        }
    }
}

