/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.collector;

import com.scalagent.joram.mom.dest.collector.Collector;
import com.scalagent.joram.mom.dest.collector.CollectorDestination;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;

public class URLCollector
implements Collector,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILE = "collector.file";
    public static final String PATH = "collector.path";
    public static final String HOST = "collector.host";
    public static final String URL = "collector.url";
    public static final String TYPE = "collector.type";
    private CollectorDestination collectorDest;
    private String urlStr = null;
    private int type = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResource(String spec, org.objectweb.joram.shared.util.Properties prop) throws IOException {
        ByteArrayOutputStream baos = null;
        FilterOutputStream bos = null;
        try {
            URL url = new URL(spec);
            URLConnection urlc = url.openConnection();
            InputStream is = urlc.getInputStream();
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            prop.put(FILE, url.getFile());
            prop.put(PATH, url.getPath());
            prop.put(HOST, url.getHost());
            int c = is.read();
            while (c != -1) {
                ((BufferedOutputStream)bos).write(c);
                c = is.read();
            }
            ((BufferedOutputStream)bos).flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    public void check() throws IOException {
        org.objectweb.joram.shared.util.Properties prop = new org.objectweb.joram.shared.util.Properties();
        prop.put(URL, this.urlStr);
        byte[] tab = this.getResource(this.urlStr, prop);
        this.collectorDest.sendMessage(this.type, tab, prop);
    }

    public void setCollectorDestination(CollectorDestination collectorDest) {
        this.collectorDest = collectorDest;
    }

    public void setProperties(Properties properties) {
        this.urlStr = properties.getProperty(URL);
        try {
            this.type = ConversionHelper.toByte(properties.getProperty(TYPE));
        }
        catch (MessageValueException e) {
            this.type = 5;
        }
    }
}

