/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.pool;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.pool.PooledConnectionFactory;

public class PooledConnection
implements javax.jms.Connection {
    PooledConnectionFactory pcf;
    Connection delegate;
    String name;
    String password;

    public PooledConnection(PooledConnectionFactory pcf, String name, String password) throws JMSException {
        this.pcf = pcf;
        this.name = name;
        this.password = password;
        this.delegate = (Connection)pcf.cf.createConnection(name, password);
    }

    public void close() throws JMSException {
        this.delegate.cleanup();
        this.delegate.setExceptionListener(null);
        this.delegate.stop();
        this.pcf.free(this);
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("Forbidden call on a PooledConnection.");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String selector, ServerSessionPool sessPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("Forbidden call on a PooledConnection.");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.delegate.createSession(transacted, acknowledgeMode);
    }

    public String getClientID() throws JMSException {
        return this.delegate.getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.delegate.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.delegate.getMetaData();
    }

    public void setClientID(String clientID) throws JMSException {
        this.delegate.setClientID(clientID);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.delegate.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.delegate.start();
    }

    public void stop() throws JMSException {
        this.delegate.stop();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",delegate=").append(this.delegate);
        strbuf.append(",name=").append(this.name);
        strbuf.append(",pcf=").append(this.pcf);
        strbuf.append("]");
        return strbuf.toString();
    }
}

