/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.Range;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class NakAckHeader
extends Header
implements Streamable {
    public static final byte MSG = 1;
    public static final byte XMIT_REQ = 2;
    public static final byte XMIT_RSP = 3;
    byte type = 0;
    long seqno = -1L;
    Range range = null;
    Address sender;
    private static final long serialVersionUID = -4305600151593420827L;

    public NakAckHeader() {
    }

    public NakAckHeader(byte type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    public NakAckHeader(byte type, long low, long high) {
        this.type = type;
        this.range = new Range(low, high);
    }

    public NakAckHeader(byte type, long low, long high, Address sender) {
        this(type, low, high);
        this.sender = sender;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeLong(this.seqno);
        if (this.range != null) {
            out.writeBoolean(true);
            this.range.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeObject(this.sender);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.seqno = in.readLong();
        boolean read_range = in.readBoolean();
        if (read_range) {
            this.range = new Range();
            this.range.readExternal(in);
        }
        this.sender = (Address)in.readObject();
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        out.writeLong(this.seqno);
        Util.writeStreamable(this.range, out);
        Util.writeAddress(this.sender, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.type = in.readByte();
        this.seqno = in.readLong();
        this.range = (Range)Util.readStreamable(Range.class, in);
        this.sender = Util.readAddress(in);
    }

    public int size() {
        int retval = 1;
        retval += 8;
        ++retval;
        if (this.range != null) {
            retval += 16;
        }
        return retval += Util.size(this.sender);
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader(this.type, this.seqno);
        ret.range = this.range;
        ret.sender = this.sender;
        return ret;
    }

    public static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
        }
        return "<undefined>";
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[").append(NakAckHeader.type2Str(this.type));
        switch (this.type) {
            case 1: {
                ret.append(", seqno=").append(this.seqno);
                break;
            }
            case 2: {
                if (this.range == null) break;
                ret.append(", range=" + this.range);
                break;
            }
        }
        if (this.sender != null) {
            ret.append(", sender=").append(this.sender);
        }
        ret.append(']');
        return ret.toString();
    }
}

