/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.annotation.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.IAnnotationProcessor;
import org.ow2.util.annotation.processor.ProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationProcessor
implements IAnnotationProcessor {
    private List<IAnnotationHandler> handlers = new ArrayList<IAnnotationHandler>();

    @Override
    public void process(Object target) throws ProcessorException {
        Class<?> clazz = target.getClass();
        this.process(target, clazz);
    }

    @Override
    public void process(Object target, Class<?> clazz) throws ProcessorException {
        Field[] fields;
        Method[] methods;
        if (clazz.getSuperclass() != null) {
            this.process(target, clazz.getSuperclass());
        }
        this.processClassAnnotations(target, clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.processMethodAnnotations(target, method);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            this.processFieldAnnotations(target, field);
        }
    }

    protected void processFieldAnnotations(Object target, Field field) throws ProcessorException {
        Annotation[] annotations = field.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                for (IAnnotationHandler handler : this.handlers) {
                    if (!handler.isSupported(annotation.annotationType())) continue;
                    handler.process(annotation, field, target);
                }
            }
        }
    }

    protected void processMethodAnnotations(Object target, Method method) throws ProcessorException {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                for (IAnnotationHandler handler : this.handlers) {
                    if (!handler.isSupported(annotation.annotationType())) continue;
                    handler.process(annotation, method, target);
                }
            }
        }
    }

    protected void processClassAnnotations(Object target, Class<?> clazz) throws ProcessorException {
        Annotation[] annotations = clazz.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                for (IAnnotationHandler handler : this.handlers) {
                    if (!handler.isSupported(annotation.annotationType())) continue;
                    handler.process(annotation, clazz, target);
                }
            }
        }
    }

    @Override
    public void addAnnotationHandler(IAnnotationHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void removeAnnotationHandler(IAnnotationHandler handler) {
        this.handlers.remove(handler);
    }
}

