/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.SCServerMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.common.monitoring.DumpAttributes;
import java.util.Enumeration;

public class SCServer
implements SCServerMBean {
    public short getServerId() {
        return AgentServer.getServerId();
    }

    public String getName() {
        return AgentServer.getName();
    }

    public void start() {
        try {
            AgentServer.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        AgentServer.stop(false);
    }

    public int getStatus() {
        return AgentServer.getStatus();
    }

    public String getStatusInfo() {
        return AgentServer.getStatusInfo();
    }

    public String[] getServers() {
        Enumeration e = AgentServer.elementsServerDesc();
        String[] servers = new String[AgentServer.getServerNb()];
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (e.hasMoreElements()) {
            ServerDesc server = (ServerDesc)e.nextElement();
            strBuf.append("sid=").append(server.sid);
            strBuf.append(",name=").append(server.name);
            if (server.gateway == -1) {
                strBuf.append(",gateway=").append(server.gateway);
            } else {
                strBuf.append(",host=").append(server.getHostname()).append(':').append(server.getPort());
                strBuf.append(",active=").append(server.active);
                strBuf.append(",last=").append(server.last);
            }
            servers[i] = strBuf.toString();
            strBuf.setLength(0);
            ++i;
        }
        return servers;
    }

    public void dumpAttributes(String name, String path) {
        DumpAttributes.dumpAttributes((String)name, (String)path);
    }
}

