/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.StoppedQueueException;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ActivateConsumerRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerSetListRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

abstract class MessageConsumerListener
implements ReplyListener {
    public static Logger logger = Debug.getLogger((String)MessageConsumerListener.class.getName());
    private boolean queueMode;
    private boolean durable;
    private String selector;
    private String targetName;
    private volatile int requestId;
    private int status;
    private Vector messagesToAck;
    private volatile int messageCount;
    private volatile int receiveStatus;
    private boolean topicMsgInputPassivated;
    private int queueMessageReadMax;
    private RequestMultiplexer rm;
    private int topicActivationThreshold;
    private int topicPassivationThreshold;
    private int topicAckBufferMax;
    private MessageListener listener;

    MessageConsumerListener(boolean queueMode, boolean durable, String selector, String targetName, MessageListener listener, int queueMessageReadMax, int topicActivationThreshold, int topicPassivationThreshold, int topicAckBufferMax, RequestMultiplexer reqMultiplexer) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener(" + queueMode + ',' + durable + ',' + selector + ',' + targetName + ',' + listener + ',' + queueMessageReadMax + ',' + topicActivationThreshold + ',' + topicPassivationThreshold + ',' + topicAckBufferMax + ',' + reqMultiplexer + ')'));
        }
        this.queueMode = queueMode;
        this.durable = durable;
        this.selector = selector;
        this.targetName = targetName;
        this.listener = listener;
        this.queueMessageReadMax = queueMessageReadMax;
        this.topicActivationThreshold = topicActivationThreshold;
        this.topicPassivationThreshold = topicPassivationThreshold;
        this.topicAckBufferMax = topicAckBufferMax;
        this.rm = reqMultiplexer;
        this.messagesToAck = new Vector(0);
        this.requestId = -1;
        this.messageCount = 0;
        this.topicMsgInputPassivated = false;
        this.setStatus(0);
        this.setReceiveStatus(0);
    }

    protected final int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener.setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    private void setReceiveStatus(int s) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener.setReceiveStatus(" + ReceiveStatus.toString(s) + ')'));
        }
        this.receiveStatus = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decreaseMessageCount(int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MessageConsumerListener.decreaseMessageCount()");
        }
        MessageConsumerListener messageConsumerListener = this;
        synchronized (messageConsumerListener) {
            --this.messageCount;
        }
        if (this.queueMode) {
            boolean subscribe = false;
            Object[] toAck = null;
            MessageConsumerListener messageConsumerListener2 = this;
            synchronized (messageConsumerListener2) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> messageCount = " + this.messageCount));
                }
                if (this.messageCount < this.queueMessageReadMax && this.receiveStatus == 2) {
                    subscribe = true;
                    if (ackMode == 3) {
                        Vector vector = this.messagesToAck;
                        synchronized (vector) {
                            if (this.messagesToAck.size() > 0) {
                                toAck = new String[this.messagesToAck.size()];
                                this.messagesToAck.copyInto(toAck);
                                this.messagesToAck.clear();
                            }
                        }
                    }
                }
            }
            if (subscribe) {
                this.subscribe((String[])toAck);
            }
        } else {
            messageConsumerListener = this;
            synchronized (messageConsumerListener) {
                if (this.topicMsgInputPassivated) {
                    if (this.messageCount < this.topicActivationThreshold) {
                        this.activateMessageInput();
                        this.topicMsgInputPassivated = false;
                    }
                } else if (this.messageCount > this.topicPassivationThreshold) {
                    this.passivateMessageInput();
                    this.topicMsgInputPassivated = true;
                }
            }
        }
        if (ackMode == 3 && this.messageCount == 0) {
            this.acknowledge(0);
        }
        return this.messageCount;
    }

    synchronized void start() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MessageConsumerListener.start()");
        }
        if (this.status != 0) {
            throw new java.lang.IllegalStateException("Status error");
        }
        this.subscribe(null);
        this.setStatus(1);
    }

    private void subscribe(String[] toAck) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MessageConsumerListener.subscribe()");
        }
        ConsumerSetListRequest req = new ConsumerSetListRequest(this.targetName, this.selector, this.queueMode, toAck, this.queueMessageReadMax);
        this.setReceiveStatus(1);
        this.rm.sendRequest((AbstractJmsRequest)req, this);
        this.requestId = req.getRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"MessageConsumerListener.close()");
        }
        MessageConsumerListener messageConsumerListener = this;
        synchronized (messageConsumerListener) {
            while (this.status == 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.status == 0 || this.status == 3) {
                return;
            }
            this.rm.abortRequest(this.requestId);
            this.acknowledge(0);
            this.setStatus(3);
        }
        if (this.queueMode) {
            ConsumerUnsetListRequest unsetLR = new ConsumerUnsetListRequest(this.queueMode);
            unsetLR.setTarget(this.targetName);
            unsetLR.setCancelledRequestId(this.requestId);
            this.rm.sendRequest((AbstractJmsRequest)unsetLR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(int threshold) {
        block7: {
            try {
                Vector vector = this.messagesToAck;
                synchronized (vector) {
                    if (this.messagesToAck.size() > threshold) {
                        ConsumerAckRequest ack = new ConsumerAckRequest(this.targetName, this.queueMode);
                        for (int i = 0; i < this.messagesToAck.size(); ++i) {
                            String msgId = (String)this.messagesToAck.elementAt(i);
                            ack.addId(msgId);
                        }
                        this.rm.sendRequest((AbstractJmsRequest)ack);
                        this.messagesToAck.clear();
                    }
                }
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block7;
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
        }
    }

    public synchronized boolean replyReceived(AbstractJmsReply reply) throws AbortedRequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener.replyReceived(" + reply + ')'));
        }
        if (this.status == 3) {
            throw new AbortedRequestException();
        }
        if (this.queueMode) {
            this.setReceiveStatus(2);
        }
        try {
            ConsumerMessages cm = (ConsumerMessages)reply;
            this.messageCount += cm.getMessageCount();
            this.pushMessages(cm);
        }
        catch (StoppedQueueException exc) {
            throw new AbortedRequestException();
        }
        catch (JMSException exc) {
            throw new AbortedRequestException();
        }
        return this.queueMode;
    }

    public abstract void pushMessages(ConsumerMessages var1) throws JMSException;

    public void replyAborted(int requestId) {
    }

    public synchronized boolean isClosed() {
        return this.status == 3;
    }

    public final MessageListener getMessageListener() {
        return this.listener;
    }

    public final boolean getQueueMode() {
        return this.queueMode;
    }

    public final String getTargetName() {
        return this.targetName;
    }

    protected void activateListener(Message msg, MessageListener listener, int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener.onMessage(" + msg + ')'));
        }
        this.decreaseMessageCount(ackMode);
        try {
            listener.onMessage((javax.jms.Message)msg);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> consumer.onMessage(" + msg + ") returned"));
            }
        }
        catch (RuntimeException re) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)re);
            }
            JMSException exc = new JMSException(re.toString());
            exc.setLinkedException((Exception)re);
            throw exc;
        }
    }

    public abstract void onMessage(Message var1, MessageListener var2, int var3) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg, int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MessageConsumerListener.onMessage(" + msg + ')'));
        }
        if (this.listener != null) {
            MessageConsumerListener messageConsumerListener = this;
            synchronized (messageConsumerListener) {
                if (this.status != 1) {
                    this.notifyAll();
                    throw new IllegalStateException("Message listener closed");
                }
                this.setStatus(2);
            }
            try {
                this.activateListener(msg, this.listener, ackMode);
            }
            finally {
                messageConsumerListener = this;
                synchronized (messageConsumerListener) {
                    if (this.status == 2) {
                        this.setStatus(1);
                    }
                    this.notifyAll();
                }
            }
        }
        throw new JMSException("Null listener");
    }

    void ack(String msgId, int ackMode) throws JMSException {
        if (ackMode == 3) {
            this.messagesToAck.addElement(msgId);
            if (!this.queueMode) {
                this.acknowledge(this.topicAckBufferMax);
            }
        } else {
            ConsumerAckRequest ack = new ConsumerAckRequest(this.targetName, this.queueMode);
            ack.addId(msgId);
            this.rm.sendRequest((AbstractJmsRequest)ack);
        }
    }

    void activateMessageInput() throws JMSException {
        this.rm.sendRequest((AbstractJmsRequest)new ActivateConsumerRequest(this.targetName, true));
    }

    void passivateMessageInput() throws JMSException {
        this.rm.sendRequest((AbstractJmsRequest)new ActivateConsumerRequest(this.targetName, false));
    }

    private static class ReceiveStatus {
        public static final int INIT = 0;
        public static final int WAIT_FOR_REPLY = 1;
        public static final int CONSUMING_REPLY = 2;
        private static final String[] names = new String[]{"INIT", "WAIT_FOR_REPLY", "CONSUMING_REPLY"};

        private ReceiveStatus() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    protected static class Status {
        public static final int INIT = 0;
        public static final int RUN = 1;
        public static final int ON_MSG = 2;
        public static final int CLOSE = 3;
        private static final String[] names = new String[]{"INIT", "RUN", "ON_MSG", "CLOSE"};

        protected Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

