/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.keepbusy.clue;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.keepbusy.ShareMethod;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IIdentityReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IdentityReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IdentityWeakReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.KeepBusyPool;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.PoolItemInfo;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.PoolStackTrace;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.NoWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepBusyCluePool<E, C>
extends KeepBusyPool<E>
implements ICluePool<E, C> {
    private static final Log LOG = LogFactory.getLog(KeepBusyCluePool.class);
    private Map<IIdentityReference<E>, PoolItemInfo> busyPoolItemList;
    private IClueManager<E, C> clueManager;
    private ICluePool<E, C> cluePool;
    private Lock lock;

    public KeepBusyCluePool(ICluePool<E, C> cluePool, IClueManager<E, C> clueManager) {
        super(cluePool);
        if (clueManager == null) {
            throw new IllegalArgumentException();
        }
        this.busyPoolItemList = this.getBusyPoolItemList();
        this.cluePool = cluePool;
        this.clueManager = clueManager;
        this.lock = this.getLock();
    }

    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        return this.get(null, timeout);
    }

    private E lookForAvailableInstance(C clue) throws PoolException, InterruptedException {
        try {
            E poolItem = this.cluePool.get(clue, NoWaitControl.INSTANCE);
            if (this.getShareMethod0() != ShareMethod.NEVER_SHARE) {
                this.cluePool.signalAllWaiters();
            }
            LOG.debug((Object)"clue pool returns NEW {0}", new Object[]{poolItem});
            return poolItem;
        }
        catch (TimeoutPoolException e) {
            return null;
        }
    }

    private E lookForSharedInstance(C clue) {
        Iterator<IIdentityReference<E>> iterator = this.busyPoolItemList.keySet().iterator();
        while (iterator.hasNext()) {
            E poolItem = iterator.next().getReference();
            if (poolItem == null || !this.clueManager.tryMatch(poolItem, clue)) continue;
            LOG.debug((Object)"clue pool returns SHARED {0}", new Object[]{poolItem});
            return poolItem;
        }
        return null;
    }

    private E lookForInstance(C clue) throws PoolException, InterruptedException {
        E poolItem;
        switch (this.getShareMethod0()) {
            default: {
                poolItem = this.lookForAvailableInstance(clue);
                break;
            }
            case SHARE_AS_LAST_SOLUTION: {
                poolItem = this.lookForAvailableInstance(clue);
                if (poolItem != null) break;
                poolItem = this.lookForSharedInstance(clue);
                break;
            }
            case SHARE_IF_POSSIBLE: {
                poolItem = this.lookForSharedInstance(clue);
                if (poolItem != null) break;
                poolItem = this.lookForAvailableInstance(clue);
            }
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(C clue, IWaitControl timeout) throws PoolException, InterruptedException {
        E poolItem = null;
        this.lock.lock();
        try {
            IdentityReference<Object> strongReference;
            PoolItemInfo poolItemInfo;
            this.expunge();
            poolItem = this.lookForInstance(clue);
            if (poolItem == null) {
                boolean stopWaiting = false;
                if (!timeout.canContinueToWait()) {
                    throw new TimeoutPoolException();
                }
                while (!stopWaiting) {
                    block18: {
                        try {
                            Object var6_10;
                            timeout.pushWaitAuthorization(this.getCurrentWaitAuthorization());
                            this.lock.unlock();
                            try {
                                poolItem = this.cluePool.get(clue, timeout);
                                var6_10 = null;
                                this.lock.lock();
                                timeout.popWaitAuthorization();
                            }
                            catch (Throwable throwable) {
                                var6_10 = null;
                                this.lock.lock();
                                timeout.popWaitAuthorization();
                                throw throwable;
                            }
                            if (this.getShareMethod0() != ShareMethod.NEVER_SHARE) {
                                this.getCurrentWaitAuthorization().forbidWait();
                                this.setCurrentWaitAuthorization(new WaitAuthorization());
                                this.cluePool.signalAllWaiters();
                            }
                        }
                        catch (WaiterInterruptedException e) {
                            timeout.verifyInterrupted();
                            if (this.getShareMethod0() != ShareMethod.NEVER_SHARE) {
                                poolItem = this.lookForSharedInstance(clue);
                            }
                        }
                        catch (TimeoutPoolException e) {
                            if (this.getShareMethod0() == ShareMethod.NEVER_SHARE) break block18;
                            poolItem = this.lookForSharedInstance(clue);
                        }
                    }
                    if (poolItem != null) {
                        stopWaiting = true;
                        continue;
                    }
                    if (timeout.canContinueToWait()) continue;
                    throw new TimeoutPoolException();
                }
            }
            if ((poolItemInfo = this.busyPoolItemList.get(strongReference = new IdentityReference<Object>(poolItem))) == null) {
                IIdentityReference<Object> toPutIdentityReference;
                poolItemInfo = new PoolItemInfo();
                switch (this.getReferenceType()) {
                    case STRONG: {
                        toPutIdentityReference = strongReference;
                        break;
                    }
                    default: {
                        toPutIdentityReference = new IdentityWeakReference<Object>(poolItem, this.getReferenceQueue());
                    }
                }
                this.busyPoolItemList.put(toPutIdentityReference, poolItemInfo);
            } else {
                poolItemInfo.setBusyCount(poolItemInfo.getBusyCount() + 1);
            }
            poolItemInfo.addStackTraceElements(new PoolStackTrace());
            Object var8_11 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.lock.unlock();
            throw throwable;
        }
        return poolItem;
    }
}

