/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.MessageInputStream;
import java.io.IOException;

public abstract class ByteArrayMessageInputStream
extends MessageInputStream {
    public ByteArrayMessageInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArrayMessageInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
    }

    public final int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    protected final void readFully(int length) throws IOException {
    }
}

