/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;

public class HostKey {
    private static final byte[] sshdss = "ssh-dss".getBytes();
    private static final byte[] sshrsa = "ssh-rsa".getBytes();
    protected static final int GUESS = 0;
    public static final int SSHDSS = 1;
    public static final int SSHRSA = 2;
    static final int UNKNOWN = 3;
    protected String host;
    protected int type;
    protected byte[] key;

    public HostKey(String host, byte[] key) throws JSchException {
        this(host, 0, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostKey(String host, int type, byte[] key) throws JSchException {
        this.host = host;
        if (type == 0) {
            if (key[8] == 100) {
                this.type = 1;
            } else {
                if (key[8] != 114) throw new JSchException("invalid key type");
                this.type = 2;
            }
        } else {
            this.type = type;
        }
        this.key = key;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        if (this.type == 1) {
            return new String(sshdss);
        }
        if (this.type == 2) {
            return new String(sshrsa);
        }
        return "UNKNOWN";
    }

    public String getKey() {
        return new String(Util.toBase64(this.key, 0, this.key.length));
    }

    public String getFingerPrint(JSch jsch) {
        HASH hash = null;
        try {
            Class<?> c = Class.forName(JSch.getConfig("md5"));
            hash = (HASH)c.newInstance();
        }
        catch (Exception e) {
            System.err.println("getFingerPrint: " + e);
        }
        return Util.getFingerPrint(hash, this.key);
    }

    boolean isMatched(String _host) {
        return this.isIncluded(_host);
    }

    private boolean isIncluded(String _host) {
        int i = 0;
        String hosts = this.host;
        int hostslen = hosts.length();
        int hostlen = _host.length();
        while (i < hostslen) {
            int j = hosts.indexOf(44, i);
            if (j == -1) {
                if (hostlen != hostslen - i) {
                    return false;
                }
                return hosts.regionMatches(true, i, _host, 0, hostlen);
            }
            if (hostlen == j - i && hosts.regionMatches(true, i, _host, 0, hostlen)) {
                return true;
            }
            i = j + 1;
        }
        return false;
    }
}

