/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.util.logging.Logger;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.util.ExchangeHelper;

public class FailureResistentExceptionHandlerProcessor
implements Processor {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private String destination;

    public FailureResistentExceptionHandlerProcessor(String destination) {
        this.destination = destination;
    }

    public void process(Exchange exchange) throws Exception {
        if (ExchangeHelper.isFailureHandled((Exchange)exchange)) {
            this.logger.warning("ExchangeHelper.isFailureHandled(exchange) is true for exchange " + exchange);
            return;
        }
        try {
            Message errorMessage = exchange.getIn().copy();
            Producer errorProducer = exchange.getContext().getEndpoint(this.destination).createProducer();
            Exchange errorExchange = errorProducer.createExchange();
            errorExchange.setIn(errorMessage);
            errorProducer.process(errorExchange);
            ExchangeHelper.setFailureHandled((Exchange)exchange);
            exchange.setProperty("CamelErrorHandlerHandled", (Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            Thread.sleep(5000L);
            throw new Exception("Error handling failed", t);
        }
    }
}

