/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnmarshalXPathEngine {
    private static UnmarshalXPathEngine instance = null;
    private XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();

    public static UnmarshalXPathEngine getInstance() {
        if (instance == null) {
            instance = new UnmarshalXPathEngine();
        }
        return instance;
    }

    public Object selectSingleNode(Node contextNode, XMLField xmlField, XMLNamespaceResolver xmlNamespaceResolver) throws XMLMarshalException {
        try {
            if (contextNode == null) {
                return null;
            }
            XPathFragment xPathFragment = xmlField.getXPathFragment();
            if (xPathFragment.shouldExecuteSelectNodes()) {
                return this.xmlPlatform.selectSingleNodeAdvanced(contextNode, xmlField.getXPath(), xmlNamespaceResolver);
            }
            Object result = this.selectSingleNode(contextNode, xPathFragment, xmlNamespaceResolver);
            if (result == XMLRecord.noEntry) {
                if (xmlField.getLastXPathFragment().nameIsText() || xmlField.getLastXPathFragment().isAttribute()) {
                    return result;
                }
                return null;
            }
            return result;
        }
        catch (Exception x) {
            throw XMLMarshalException.invalidXPathString(xmlField.getXPath(), x);
        }
    }

    private Object selectSingleNode(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        Node resultNode = this.getSingleNode(contextNode, xPathFragment, xmlNamespaceResolver);
        if (resultNode == null) {
            if (!xPathFragment.nameIsText()) {
                return XMLRecord.noEntry;
            }
            return null;
        }
        if (xPathFragment.getNextFragment() == null) {
            return resultNode;
        }
        return this.selectSingleNode(resultNode, xPathFragment.getNextFragment(), xmlNamespaceResolver);
    }

    public NodeList selectNodes(Node contextNode, XMLField xmlField, XMLNamespaceResolver xmlNamespaceResolver) throws XMLMarshalException {
        try {
            if (contextNode == null) {
                return null;
            }
            XPathFragment xPathFragment = xmlField.getXPathFragment();
            if (xPathFragment.shouldExecuteSelectNodes()) {
                return this.xmlPlatform.selectNodesAdvanced(contextNode, xmlField.getXPath(), xmlNamespaceResolver);
            }
            return this.selectNodes(contextNode, xPathFragment, xmlNamespaceResolver);
        }
        catch (Exception x) {
            throw XMLMarshalException.invalidXPathString(xmlField.getXPath(), x);
        }
    }

    private NodeList selectNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        NodeList resultNodes = this.getNodes(contextNode, xPathFragment, xmlNamespaceResolver);
        if (xPathFragment.getNextFragment() != null) {
            XMLNodeList result = new XMLNodeList();
            int numberOfResultNodes = resultNodes.getLength();
            for (int x = 0; x < numberOfResultNodes; ++x) {
                Node resultNode = resultNodes.item(x);
                result.addAll(this.selectNodes(resultNode, xPathFragment.getNextFragment(), xmlNamespaceResolver));
            }
            return result;
        }
        return resultNodes;
    }

    private Node getSingleNode(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        if (xPathFragment.isAttribute()) {
            return this.selectSingleAttribute(contextNode, xPathFragment, xmlNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectSingleText(contextNode);
        }
        if (xPathFragment.isSelfFragment()) {
            return contextNode;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver);
    }

    private NodeList getNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        if (xPathFragment.isAttribute()) {
            return this.selectAttributeNodes(contextNode, xPathFragment, xmlNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectTextNodes(contextNode);
        }
        if (xPathFragment.isSelfFragment()) {
            XMLNodeList xmlNodeList = new XMLNodeList(1);
            xmlNodeList.add(contextNode);
            return xmlNodeList;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectElementNodes(contextNode, xPathFragment, xmlNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectElementNodes(contextNode, xPathFragment, xmlNamespaceResolver);
    }

    private Node selectSingleAttribute(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        if (xPathFragment.hasNamespace()) {
            Element contextElement = (Element)contextNode;
            String attributeNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            return contextElement.getAttributeNodeNS(attributeNamespaceURI, xPathFragment.getLocalName());
        }
        Element contextElement = (Element)contextNode;
        return contextElement.getAttributeNode(xPathFragment.getShortName());
    }

    private NodeList selectAttributeNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleAttribute(contextNode, xPathFragment, xmlNamespaceResolver);
        if (null != child) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        for (Node child = contextNode.getFirstChild(); null != child; child = child.getNextSibling()) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() != 1 || !this.sameName(child, xPathFragment.getLocalName()) || !this.sameNamespaceURI(child, elementNamespaceURI)) continue;
            return child;
        }
        return null;
    }

    public NodeList selectElementNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        for (Node child = contextNode.getFirstChild(); null != child; child = child.getNextSibling()) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() != 1 || !this.sameName(child, xPathFragment.getLocalName()) || !this.sameNamespaceURI(child, elementNamespaceURI)) continue;
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, int position) {
        for (Node child = contextNode.getFirstChild(); null != child; child = child.getNextSibling()) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() != 1 || !this.sameName(child, xPathFragment.getShortName()) || !this.sameNamespaceURI(child, elementNamespaceURI) || 0 != --position) continue;
            return child;
        }
        return null;
    }

    private NodeList selectElementNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, int position) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver, position);
        if (null != child) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleText(Node contextNode) {
        NodeList childrenNodes = contextNode.getChildNodes();
        int numberOfNodes = childrenNodes.getLength();
        if (numberOfNodes == 0) {
            return null;
        }
        if (numberOfNodes == 1) {
            Node child = childrenNodes.item(0);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                return child;
            }
            return null;
        }
        String returnVal = null;
        for (int i = 0; i < numberOfNodes; ++i) {
            String val;
            Node next = childrenNodes.item(i);
            if (next.getNodeType() != 3 && next.getNodeType() != 4 || (val = next.getNodeValue()) == null) continue;
            if (returnVal == null) {
                returnVal = new String();
            }
            if (next.getNodeType() == 4) {
                val = val.trim();
            }
            returnVal = returnVal + val;
        }
        if (returnVal != null) {
            return contextNode.getOwnerDocument().createTextNode(returnVal);
        }
        return null;
    }

    private NodeList selectTextNodes(Node contextNode) {
        Node n = this.selectSingleText(contextNode);
        XMLNodeList xmlNodeList = new XMLNodeList();
        if (n != null) {
            xmlNodeList.add(n);
        }
        return xmlNodeList;
    }

    private boolean sameNamespaceURI(Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI == namespaceURI) {
            return true;
        }
        if (nodeNamespaceURI == null && namespaceURI.equals("")) {
            return true;
        }
        if (namespaceURI == null && nodeNamespaceURI.equals("")) {
            return true;
        }
        return null != nodeNamespaceURI && nodeNamespaceURI.equals(namespaceURI);
    }

    private boolean sameName(Node node, String name) {
        return name.equals(node.getLocalName()) || name.equals(node.getNodeName());
    }
}

