/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.FetchPathImpl;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FromImpl<Z, X>
extends PathImpl<Z, X>
implements From<Z, X> {
    private Set<Join<X, ?>> _joins;
    private Set<Fetch<X, ?>> _fetches;
    private Type<X> type;

    protected FromImpl(AbstractManagedType<X> type) {
        super(type.getJavaType());
        this.type = type;
    }

    protected FromImpl(PathImpl<?, Z> parent, Members.Member<? super Z, ?> m, Class<X> x) {
        super(parent, m, x);
        this.type = m.getType();
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    public Set<Join<X, ?>> getJoins() {
        return Expressions.returnCopy(this._joins);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        Joins.SingularJoin join = new Joins.SingularJoin(this, (Members.SingularAttributeImpl)attribute, jt);
        this.addJoin(join);
        return join;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        Joins.Collection join = new Joins.Collection(this, (Members.CollectionAttributeImpl)collection, jt);
        this.addJoin((Join<X, ?>)join);
        return join;
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        Joins.Set join = new Joins.Set(this, (Members.SetAttributeImpl)set, jt);
        this.addJoin((Join<X, ?>)join);
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        Joins.List join = new Joins.List(this, (Members.ListAttributeImpl)list, jt);
        this.addJoin((Join<X, ?>)join);
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        Joins.Map join = new Joins.Map(this, (Members.MapAttributeImpl)map, jt);
        this.addJoin((Join<X, ?>)join);
        return join;
    }

    public <W, Y> Join<W, Y> join(String attr) {
        return this.join(attr, JoinType.INNER);
    }

    public <W, Y> Join<W, Y> join(String name, JoinType jt) {
        this.assertJoinable(this.type);
        ManagedType mType = (ManagedType)this.type;
        Attribute attr = mType.getAttribute(name);
        this.assertJoinable((Type<?>)attr.getDeclaringType());
        if (attr instanceof SingularAttribute) {
            return this.join((SingularAttribute)attr, jt);
        }
        if (attr instanceof ListAttribute) {
            return this.join((ListAttribute)attr, jt);
        }
        if (attr instanceof SetAttribute) {
            return this.join((SetAttribute)attr, jt);
        }
        if (attr instanceof CollectionAttribute) {
            return this.join((CollectionAttribute)attr, jt);
        }
        if (attr instanceof MapAttribute) {
            return this.join((MapAttribute)attr, jt);
        }
        throw new IllegalArgumentException(name);
    }

    public <W, Y> CollectionJoin<W, Y> joinCollection(String attr) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getCollection(attr), JoinType.INNER);
    }

    public <W, Y> CollectionJoin<W, Y> joinCollection(String attr, JoinType jt) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getCollection(attr), jt);
    }

    public <W, Y> ListJoin<W, Y> joinList(String attr) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getList(attr), JoinType.INNER);
    }

    public <W, Y> ListJoin<W, Y> joinList(String attr, JoinType jt) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getList(attr), jt);
    }

    public <W, K, V> MapJoin<W, K, V> joinMap(String attr) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getMap(attr));
    }

    public <W, K, V> MapJoin<W, K, V> joinMap(String attr, JoinType jt) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getMap(attr));
    }

    public <W, Y> SetJoin<W, Y> joinSet(String attr) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getSet(attr));
    }

    public <W, Y> SetJoin<W, Y> joinSet(String attr, JoinType jt) {
        this.assertJoinable(this.type);
        return this.join(((ManagedType)this.type).getSet(attr), jt);
    }

    void assertJoinable(Type<?> type) {
        if (type.getPersistenceType() == Type.PersistenceType.BASIC) {
            throw new IllegalArgumentException(this + " is a basic path and can not be navigated to ");
        }
    }

    private void addJoin(Join<X, ?> join) {
        if (this._joins == null) {
            this._joins = new HashSet();
        }
        this._joins.add(join);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)assoc, jt);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)assoc, jt);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <X, Y> Fetch<X, Y> fetch(String assocName) {
        return this.fetch(assocName, JoinType.INNER);
    }

    public <X, Y> Fetch<X, Y> fetch(String name, JoinType jt) {
        this.assertJoinable(this.type);
        Attribute attr = ((ManagedType)this.type).getAttribute(name);
        if (attr.isCollection()) {
            return this.fetch((PluralAttribute)attr, jt);
        }
        return this.fetch((SingularAttribute)attr, jt);
    }

    public Set<Fetch<X, ?>> getFetches() {
        return Expressions.returnCopy(this._fetches);
    }

    private <Y> Fetch<X, Y> addFetch(Members.Member<? super X, Y> member, JoinType jt) {
        FetchPathImpl<? super X, Y> fetch = new FetchPathImpl<X, Y>(this, member, jt);
        if (this._fetches == null) {
            this._fetches = new HashSet();
        }
        this._fetches.add(fetch);
        return fetch;
    }

    @Override
    public void acceptVisit(CriteriaExpressionVisitor visitor) {
        Expressions.acceptVisit(visitor, this, this._joins == null ? null : this._joins.toArray(new ExpressionImpl[this._joins.size()]));
    }

    public From<Z, X> getCorrelationParent() {
        return (From)this.getCorrelatedPath();
    }
}

