/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.Iterator;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerIterator
implements Iterator<CorbaObjectHandler> {
    final CorbaStreamable[] params;
    int count;
    CorbaObjectHandler next;
    boolean isServer;

    public HandlerIterator(CorbaMessage msg, boolean server) {
        this.params = msg.getStreamableArguments();
        this.isServer = server;
        if (!this.isServer && msg.getStreamableReturn() != null) {
            this.next = msg.getStreamableReturn().getObject();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            while (this.next == null && this.count < this.params.length) {
                int mode = this.params[this.count].getMode();
                int value = 2;
                if (this.isServer) {
                    value = 1;
                }
                if (mode == value || mode == 3) {
                    this.next = this.params[this.count].getObject();
                }
                if (!this.isServer && mode == 3 && this.next instanceof CorbaPrimitiveHandler) {
                    CorbaPrimitiveHandler prim = (CorbaPrimitiveHandler)this.next;
                    prim.clear();
                }
                ++this.count;
            }
        }
        return this.next != null;
    }

    @Override
    public CorbaObjectHandler next() {
        CorbaObjectHandler current = this.next;
        this.next = null;
        return current;
    }

    @Override
    public void remove() {
    }
}

