/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.pool;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.pool.ConnectionKey;
import org.objectweb.joram.client.jms.pool.PooledConnection;

public class ConnectionPool {
    int maxFreeConnections = 10;
    private Map<ConnectionKey, LinkedList<PooledConnection>> cache = new HashMap<ConnectionKey, LinkedList<PooledConnection>>();

    public int getMaxFreeConnections() {
        return this.maxFreeConnections;
    }

    public void setMaxFreeConnections(int maxFreeConnections) {
        this.maxFreeConnections = maxFreeConnections;
    }

    public ConnectionPool(int maxFreeConnections) {
        this.maxFreeConnections = maxFreeConnections;
    }

    public PooledConnection alloc(String name, String password) {
        ConnectionKey key = new ConnectionKey(name, password);
        LinkedList<PooledConnection> pools = this.cache.get(key);
        if (pools == null || pools.isEmpty()) {
            return null;
        }
        return pools.removeFirst();
    }

    public void free(PooledConnection cnx) throws JMSException {
        ConnectionKey key = new ConnectionKey(cnx.name, cnx.password);
        LinkedList<PooledConnection> pools = this.cache.get(key);
        if (pools == null) {
            pools = new LinkedList();
            this.cache.put(key, pools);
        }
        if (pools.size() == this.maxFreeConnections) {
            cnx.delegate.close();
            return;
        }
        pools.add(cnx);
    }
}

