/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.Wrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.WrapperUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseWrapper
extends Wrapper {
    @Override
    public void setOperationInfo(OperationInfo op) {
        super.setOperationInfo(op);
        this.setName(op.getOutput().getMessageParts().get(0).getElementQName());
        this.setClassName((String)op.getOutput().getMessageParts().get(0).getProperty("RESPONSE.WRAPPER.CLASSNAME"));
    }

    @Override
    public boolean isWrapperAbsent(Method method) {
        javax.xml.ws.ResponseWrapper resWrapper = method.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        return this.getClassName() == null && (resWrapper == null || StringUtils.isEmpty(resWrapper.className()));
    }

    public String getWrapperTns(Method method) {
        RequestWrapper reqWrapper = method.getAnnotation(RequestWrapper.class);
        if (reqWrapper != null) {
            return reqWrapper.targetNamespace();
        }
        return null;
    }

    @Override
    protected List<JavaField> buildFields() {
        return this.buildFields(this.getMethod(), this.getOperationInfo().getUnwrappedOperation().getOutput());
    }

    protected List<JavaField> buildFields(Method method, MessageInfo message) {
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        Class<Void> returnType = method.getReturnType();
        JavaField field = new JavaField();
        if (CollectionUtils.isEmpty(message.getMessageParts())) {
            return fields;
        }
        MessagePartInfo part = message.getMessageParts().get(0);
        field.setName(part.getName().getLocalPart());
        field.setTargetNamespace(part.getName().getNamespaceURI());
        if (method.getAnnotation(WebResult.class) == null && method.getAnnotation(javax.xml.ws.ResponseWrapper.class) == null || method.getAnnotation(WebResult.class) != null && method.getAnnotation(WebResult.class).targetNamespace().equals("")) {
            field.setTargetNamespace("");
        }
        boolean hasReturnType = false;
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            hasReturnType = true;
            String type = this.getTypeString(method.getGenericReturnType());
            List<Annotation> jaxbAnns = WrapperUtil.getJaxbAnnotations(method);
            field.setType(type);
            field.setJaxbAnnotations(jaxbAnns.toArray(new Annotation[jaxbAnns.size()]));
        }
        fields.add(field);
        Type[] paramClasses = method.getGenericParameterTypes();
        for (MessagePartInfo mpi : message.getMessageParts()) {
            Annotation[][] paramAnnotations;
            WebParam wParam;
            ParameterizedType pt;
            Class c;
            int idx = hasReturnType ? mpi.getIndex() - 1 : mpi.getIndex();
            if (idx < 0) continue;
            String name = mpi.getName().getLocalPart();
            Type t = paramClasses[idx];
            String type = this.getTypeString(t);
            JavaField jf = new JavaField(name, type, "");
            List<Annotation> jaxbAnns = WrapperUtil.getJaxbAnnotations(method, idx - 1);
            jf.setJaxbAnnotations(jaxbAnns.toArray(new Annotation[jaxbAnns.size()]));
            if (t instanceof ParameterizedType && Holder.class.isAssignableFrom(c = (Class)(pt = (ParameterizedType)t).getRawType()) && (wParam = this.getWebParamAnnotation((paramAnnotations = method.getParameterAnnotations())[idx])) != null && !StringUtils.isEmpty(wParam.targetNamespace())) {
                jf.setTargetNamespace(wParam.targetNamespace());
            }
            fields.add(jf);
        }
        return fields;
    }

    @Override
    public WrapperBeanClass getWrapperBeanClass(Method method) {
        String methName;
        javax.xml.ws.ResponseWrapper resWrapper = method.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        String string = methName = webMethod == null ? null : webMethod.operationName();
        if (StringUtils.isEmpty(methName)) {
            methName = method.getName();
        }
        String resClassName = this.getClassName();
        String resNs = null;
        if (resWrapper != null) {
            resClassName = resWrapper.className().length() > 0 ? resWrapper.className() : resClassName;
            String string2 = resNs = resWrapper.targetNamespace().length() > 0 ? resWrapper.targetNamespace() : null;
        }
        if (resClassName == null) {
            resClassName = this.getPackageName(method) + ".jaxws." + StringUtils.capitalize(methName) + "Response";
        }
        WrapperBeanClass jClass = new WrapperBeanClass();
        jClass.setFullClassName(resClassName);
        jClass.setNamespace(resNs);
        return jClass;
    }
}

