/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.ConstantExpression;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.UnaryFunctionalOperator;
import org.apache.openjpa.persistence.query.UnaryOperatorExpression;
import org.apache.openjpa.persistence.query.Visitable;

public class SubStringExpression
extends UnaryOperatorExpression {
    private final Expression _start;
    private final Expression _length;

    public SubStringExpression(Expression op, Expression start) {
        super(op, UnaryFunctionalOperator.SUBSTR);
        this._start = start;
        this._length = null;
    }

    public SubStringExpression(Expression op, int start) {
        super(op, UnaryFunctionalOperator.SUBSTR);
        this._start = new ConstantExpression(start);
        this._length = null;
    }

    public SubStringExpression(Expression op, int start, int len) {
        super(op, UnaryFunctionalOperator.SUBSTR);
        this._start = new ConstantExpression(start);
        this._length = new ConstantExpression(len);
    }

    public SubStringExpression(Expression op, Expression start, Expression l) {
        super(op, UnaryFunctionalOperator.SUBSTR);
        this._start = start;
        this._length = new ConstantExpression(l);
    }

    public String asExpression(AliasContext ctx) {
        return (Object)((Object)this._op) + "(" + ((Visitable)((Object)this._e)).asExpression(ctx) + "," + ((Visitable)((Object)this._start)).asExpression(ctx) + (this._length == null ? "" : "," + ((Visitable)((Object)this._length)).asExpression(ctx)) + ")";
    }
}

