/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.Util;

public class BinaryTypeConverter {
    public static TypeDeclaration buildTypeDeclaration(IType type, CompilationUnitDeclaration compilationUnit, CompilationResult compilationResult) throws JavaModelException {
        PackageFragment pkg = (PackageFragment)type.getPackageFragment();
        char[][] packageName = Util.toCharArrays(pkg.names);
        if (packageName.length > 0) {
            compilationUnit.currentPackage = new ImportReference(packageName, new long[1], false, 0);
        }
        TypeDeclaration typeDeclaration = BinaryTypeConverter.convert(type, null, null, compilationResult);
        IType alreadyComputedMember = type;
        IType parent = type.getDeclaringType();
        TypeDeclaration previousDeclaration = typeDeclaration;
        while (parent != null) {
            TypeDeclaration declaration = BinaryTypeConverter.convert(parent, alreadyComputedMember, previousDeclaration, compilationResult);
            alreadyComputedMember = parent;
            previousDeclaration = declaration;
            parent = parent.getDeclaringType();
        }
        compilationUnit.types = new TypeDeclaration[]{previousDeclaration};
        return typeDeclaration;
    }

    private static FieldDeclaration convert(IField field, IType type) throws JavaModelException {
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        fieldDeclaration.name = field.getElementName().toCharArray();
        fieldDeclaration.type = BinaryTypeConverter.createTypeReference(Signature.toString(field.getTypeSignature()).toCharArray());
        fieldDeclaration.modifiers = field.getFlags();
        return fieldDeclaration;
    }

    private static AbstractMethodDeclaration convert(IMethod method, IType type, CompilationResult compilationResult) throws JavaModelException {
        int exceptionCount;
        AbstractMethodDeclaration methodDeclaration;
        AbstractMethodDeclaration decl;
        if (method.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            methodDeclaration = decl;
        } else {
            decl = type.isAnnotation() ? new AnnotationMethodDeclaration(compilationResult) : new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = BinaryTypeConverter.createTypeReference(Signature.toString(method.getReturnType()).toCharArray());
            methodDeclaration = decl;
        }
        methodDeclaration.selector = method.getElementName().toCharArray();
        int flags = method.getFlags();
        boolean isVarargs = Flags.isVarargs(flags);
        methodDeclaration.modifiers = flags & 0xFFFFFF7F;
        String[] argumentTypeNames = method.getParameterTypes();
        String[] argumentNames = method.getParameterNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        methodDeclaration.arguments = new Argument[argumentCount];
        int i = 0;
        while (i < argumentCount) {
            String argumentTypeName = argumentTypeNames[i];
            TypeReference typeReference = BinaryTypeConverter.createTypeReference(Signature.toString(argumentTypeName).toCharArray());
            if (isVarargs && i == argumentCount - 1) {
                typeReference.bits |= 0x4000;
            }
            methodDeclaration.arguments[i] = new Argument(argumentNames[i].toCharArray(), 0L, typeReference, 0);
            ++i;
        }
        String[] exceptionTypeNames = method.getExceptionTypes();
        int n = exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        if (exceptionCount > 0) {
            methodDeclaration.thrownExceptions = new TypeReference[exceptionCount];
            int i2 = 0;
            while (i2 < exceptionCount) {
                methodDeclaration.thrownExceptions[i2] = BinaryTypeConverter.createTypeReference(Signature.toString(exceptionTypeNames[i2]).toCharArray());
                ++i2;
            }
        }
        return methodDeclaration;
    }

    private static TypeDeclaration convert(IType type, IType alreadyComputedMember, TypeDeclaration alreadyComputedMemberDeclaration, CompilationResult compilationResult) throws JavaModelException {
        String[] interfaceNames;
        TypeDeclaration typeDeclaration = new TypeDeclaration(compilationResult);
        if (type.getDeclaringType() != null) {
            typeDeclaration.bits |= 0x400;
        }
        typeDeclaration.name = type.getElementName().toCharArray();
        typeDeclaration.modifiers = type.getFlags();
        if (type.getSuperclassName() != null) {
            typeDeclaration.superclass = BinaryTypeConverter.createTypeReference(type.getSuperclassName().toCharArray());
            typeDeclaration.superclass.bits |= 0x10;
        }
        int interfaceCount = (interfaceNames = type.getSuperInterfaceNames()) == null ? 0 : interfaceNames.length;
        typeDeclaration.superInterfaces = new TypeReference[interfaceCount];
        int i = 0;
        while (i < interfaceCount) {
            typeDeclaration.superInterfaces[i] = BinaryTypeConverter.createTypeReference(interfaceNames[i].toCharArray());
            typeDeclaration.superInterfaces[i].bits |= 0x10;
            ++i;
        }
        IType[] memberTypes = type.getTypes();
        int memberTypeCount = memberTypes == null ? 0 : memberTypes.length;
        typeDeclaration.memberTypes = new TypeDeclaration[memberTypeCount];
        int i2 = 0;
        while (i2 < memberTypeCount) {
            typeDeclaration.memberTypes[i2] = alreadyComputedMember != null && alreadyComputedMember.getFullyQualifiedName().equals(memberTypes[i2].getFullyQualifiedName()) ? alreadyComputedMemberDeclaration : BinaryTypeConverter.convert(memberTypes[i2], null, null, compilationResult);
            ++i2;
        }
        IField[] fields = type.getFields();
        int fieldCount = fields == null ? 0 : fields.length;
        typeDeclaration.fields = new FieldDeclaration[fieldCount];
        int i3 = 0;
        while (i3 < fieldCount) {
            typeDeclaration.fields[i3] = BinaryTypeConverter.convert(fields[i3], type);
            ++i3;
        }
        IMethod[] methods = type.getMethods();
        int methodCount = methods == null ? 0 : methods.length;
        int neededCount = 1;
        int i4 = 0;
        while (i4 < methodCount) {
            if (methods[i4].isConstructor()) {
                neededCount = 0;
                break;
            }
            ++i4;
        }
        boolean isInterface = type.isInterface();
        neededCount = isInterface ? 0 : neededCount;
        typeDeclaration.methods = new AbstractMethodDeclaration[methodCount + neededCount];
        if (neededCount != 0) {
            typeDeclaration.methods[0] = typeDeclaration.createDefaultConstructor(false, false);
        }
        boolean hasAbstractMethods = false;
        int i5 = 0;
        while (i5 < methodCount) {
            AbstractMethodDeclaration method = BinaryTypeConverter.convert(methods[i5], type, compilationResult);
            boolean isAbstract = method.isAbstract();
            if (isAbstract || isInterface) {
                method.modifiers |= 0x1000000;
            }
            if (isAbstract) {
                hasAbstractMethods = true;
            }
            typeDeclaration.methods[neededCount + i5] = method;
            ++i5;
        }
        if (hasAbstractMethods) {
            typeDeclaration.bits |= 0x800;
        }
        return typeDeclaration;
    }

    private static TypeReference createTypeReference(char[] type) {
        int max;
        int dimStart = max = type.length;
        int dim = 0;
        int identCount = 1;
        int i = 0;
        while (i < max) {
            switch (type[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    break;
                }
                case '.': {
                    ++identCount;
                }
            }
            ++i;
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(type, 0L);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(type, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, 0L);
        }
        char[][] identifiers = CharOperation.splitOn('.', type, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, new long[identifiers.length]);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, new long[identifiers.length]);
    }
}

