/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.sql.ordering.antlr.ColumnMapper;
import org.hibernate.sql.ordering.antlr.OrderByFragmentTranslator;
import org.hibernate.sql.ordering.antlr.TranslationContext;

public final class Template {
    private static final Set KEYWORDS = new HashSet();
    private static final Set BEFORE_TABLE_KEYWORDS = new HashSet();
    private static final Set FUNCTION_KEYWORDS = new HashSet();
    public static final String TEMPLATE = "$PlaceHolder$";

    private Template() {
    }

    public static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect, SQLFunctionRegistry functionRegistry) {
        return Template.renderWhereStringTemplate(sqlWhereString, TEMPLATE, dialect, functionRegistry);
    }

    public static String renderWhereStringTemplate(String sqlWhereString, String placeholder, Dialect dialect) {
        return Template.renderWhereStringTemplate(sqlWhereString, placeholder, dialect, new SQLFunctionRegistry(dialect, Collections.EMPTY_MAP));
    }

    public static String renderWhereStringTemplate(String sqlWhereString, String placeholder, Dialect dialect, SQLFunctionRegistry functionRegistry) {
        String nextToken;
        String symbols = "=><!+-*/()',|&`" + " \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, symbols, true);
        StringBuffer result = new StringBuffer();
        boolean quoted = false;
        boolean quotedIdentifier = false;
        boolean beforeTable = false;
        boolean inFromClause = false;
        boolean afterFromTable = false;
        boolean hasMore = tokens.hasMoreTokens();
        String string = nextToken = hasMore ? tokens.nextToken() : null;
        while (hasMore) {
            boolean quotedOrWhitespace;
            String token = nextToken;
            String lcToken = token.toLowerCase();
            hasMore = tokens.hasMoreTokens();
            nextToken = hasMore ? tokens.nextToken() : null;
            boolean isQuoteCharacter = false;
            if (!quotedIdentifier && "'".equals(token)) {
                quoted = !quoted;
                isQuoteCharacter = true;
            }
            if (!quoted) {
                boolean isOpenQuote;
                if ("`".equals(token)) {
                    isOpenQuote = !quotedIdentifier;
                    lcToken = isOpenQuote ? new Character(dialect.openQuote()).toString() : new Character(dialect.closeQuote()).toString();
                    token = lcToken;
                    quotedIdentifier = isOpenQuote;
                    isQuoteCharacter = true;
                } else if (!quotedIdentifier && dialect.openQuote() == token.charAt(0)) {
                    isOpenQuote = true;
                    quotedIdentifier = true;
                    isQuoteCharacter = true;
                } else if (quotedIdentifier && dialect.closeQuote() == token.charAt(0)) {
                    quotedIdentifier = false;
                    isQuoteCharacter = true;
                    isOpenQuote = false;
                } else {
                    isOpenQuote = false;
                }
                if (isOpenQuote) {
                    result.append(placeholder).append('.');
                }
            }
            boolean bl = quotedOrWhitespace = quoted || quotedIdentifier || isQuoteCharacter || Character.isWhitespace(token.charAt(0));
            if (quotedOrWhitespace) {
                result.append(token);
            } else if (beforeTable) {
                result.append(token);
                beforeTable = false;
                afterFromTable = true;
            } else if (afterFromTable) {
                if (!"as".equals(lcToken)) {
                    afterFromTable = false;
                }
                result.append(token);
            } else if (Template.isNamedParameter(token)) {
                result.append(token);
            } else if (Template.isIdentifier(token, dialect) && !Template.isFunctionOrKeyword(lcToken, nextToken, dialect, functionRegistry)) {
                result.append(placeholder).append('.').append(dialect.quote(token));
            } else {
                if (BEFORE_TABLE_KEYWORDS.contains(lcToken)) {
                    beforeTable = true;
                    inFromClause = true;
                } else if (inFromClause && ",".equals(lcToken)) {
                    beforeTable = true;
                }
                result.append(token);
            }
            if (!inFromClause || !KEYWORDS.contains(lcToken) || BEFORE_TABLE_KEYWORDS.contains(lcToken)) continue;
            inFromClause = false;
        }
        return result.toString();
    }

    public static String renderOrderByStringTemplate(String orderByFragment, Dialect dialect, SQLFunctionRegistry functionRegistry) {
        return Template.renderOrderByStringTemplate(orderByFragment, NoOpColumnMapper.INSTANCE, null, dialect, functionRegistry);
    }

    public static String renderOrderByStringTemplate(String orderByFragment, final ColumnMapper columnMapper, final SessionFactoryImplementor sessionFactory, final Dialect dialect, final SQLFunctionRegistry functionRegistry) {
        TranslationContext context = new TranslationContext(){

            public SessionFactoryImplementor getSessionFactory() {
                return sessionFactory;
            }

            public Dialect getDialect() {
                return dialect;
            }

            public SQLFunctionRegistry getSqlFunctionRegistry() {
                return functionRegistry;
            }

            public ColumnMapper getColumnMapper() {
                return columnMapper;
            }
        };
        OrderByFragmentTranslator translator = new OrderByFragmentTranslator(context);
        return translator.render(orderByFragment);
    }

    private static boolean isNamedParameter(String token) {
        return token.startsWith(":");
    }

    private static boolean isFunctionOrKeyword(String lcToken, String nextToken, Dialect dialect, SQLFunctionRegistry functionRegistry) {
        return "(".equals(nextToken) || KEYWORDS.contains(lcToken) || Template.isFunction(lcToken, nextToken, functionRegistry) || dialect.getKeywords().contains(lcToken) || FUNCTION_KEYWORDS.contains(lcToken);
    }

    private static boolean isFunction(String lcToken, String nextToken, SQLFunctionRegistry functionRegistry) {
        if ("(".equals(nextToken)) {
            return true;
        }
        SQLFunction function = functionRegistry.findSQLFunction(lcToken);
        if (function == null) {
            return false;
        }
        return !function.hasParenthesesIfNoArguments();
    }

    private static boolean isIdentifier(String token, Dialect dialect) {
        return token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && token.indexOf(46) < 0;
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("distinct");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("desc");
        KEYWORDS.add("asc");
        KEYWORDS.add("limit");
        KEYWORDS.add("any");
        KEYWORDS.add("some");
        KEYWORDS.add("exists");
        KEYWORDS.add("all");
        KEYWORDS.add("union");
        KEYWORDS.add("minus");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
        FUNCTION_KEYWORDS.add("as");
        FUNCTION_KEYWORDS.add("leading");
        FUNCTION_KEYWORDS.add("trailing");
        FUNCTION_KEYWORDS.add("from");
        FUNCTION_KEYWORDS.add("case");
        FUNCTION_KEYWORDS.add("when");
        FUNCTION_KEYWORDS.add("then");
        FUNCTION_KEYWORDS.add("else");
        FUNCTION_KEYWORDS.add("end");
    }

    public static class NoOpColumnMapper
    implements ColumnMapper {
        public static final NoOpColumnMapper INSTANCE = new NoOpColumnMapper();

        public String[] map(String reference) {
            return new String[]{reference};
        }
    }
}

