/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509Security
extends BinarySecurity {
    private String type;
    public static final String X509_V3 = "X509v3";
    private X509Certificate cachedCert = null;

    public X509Security(WSSConfig wssConfig, Element elem) throws WSSecurityException {
        super(wssConfig, elem);
        this.type = wssConfig.isBSTValuesPrefixed() ? "wsse:X509v3" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
        if (!this.getValueType().endsWith(X509_V3)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{this.type, this.getValueType()});
        }
    }

    public X509Security(WSSConfig wssConfig, Document doc) {
        super(wssConfig, doc);
        this.type = wssConfig.isBSTValuesPrefixed() ? "wsse:X509v3" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
        this.setValueType(this.type);
    }

    public X509Certificate getX509Certificate(Crypto crypto) throws WSSecurityException {
        if (this.cachedCert != null) {
            return this.cachedCert;
        }
        byte[] data = this.getToken();
        if (data == null) {
            throw new WSSecurityException(0, "invalidCertData", new Object[]{new Integer(0)});
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        this.cachedCert = crypto.loadCertificate(in);
        return this.cachedCert;
    }

    public void setX509Certificate(X509Certificate cert) throws WSSecurityException {
        if (cert == null) {
            throw new WSSecurityException(0, "noCert");
        }
        this.cachedCert = cert;
        try {
            this.setToken(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
    }

    public static String getType(WSSConfig wssConfig) {
        if (wssConfig.isBSTValuesPrefixed()) {
            return "wsse:X509v3";
        }
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    }
}

