/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.naming.api.NamingFilterKeyProvider;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.ExpressionPrinter;
import org.objectweb.medor.expression.lib.Or;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.optim.jorm.JormRule;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.lib.SelectProject;
import org.objectweb.util.monolog.api.BasicLevel;

public class JormFilteredInheritance
extends JormRule {
    public JormFilteredInheritance() {
        super("JormFilteredInheritance");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        if (qt instanceof ClassExtent && ((ClassExtent)qt).getPMapper().getMapperName().startsWith("rdb")) {
            Expression inhfilt = this.filterForExtent((ClassExtent)qt, (Class)((ClassExtent)qt).getMetaObject(), ((ClassExtent)qt).getProjectName(), null, ((JormExtent)qt).withSubClasses());
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Inheritance filter " + ExpressionPrinter.e2str(inhfilt)));
            }
            if (inhfilt != null) {
                ((JormExtent)qt).setWithSubClasses(false);
                SelectProject newSP = new SelectProject(inhfilt, "");
                HashMap<Field, PropagatedField> localyReplaced = parent == null ? null : new HashMap<Field, PropagatedField>();
                Field[] fs = qt.getTupleStructure().getFields();
                for (int i = 0; i < fs.length; ++i) {
                    PropagatedField newF = newSP.addPropagatedField(fs[i].getName(), fs[i].getType(), new QueryTreeField[]{(QueryTreeField)fs[i]});
                    if (parent == null) continue;
                    localyReplaced.put(fs[i], newF);
                }
                this.replaceUsage(parent, localyReplaced);
            }
        } else if (qt instanceof QueryNode) {
            QueryTree[] children = ((QueryNode)qt).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.rewrite(children[i], (QueryNode)qt);
            }
        }
        return qt;
    }

    private Expression filterForExtent(ClassExtent extent, Class currClass, String projectName, Expression filter, boolean withSubClass) throws MedorException {
        if (!currClass.isAbstract()) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Concrete class " + currClass.getName()));
            }
            RdbMapping mapping = (RdbMapping)currClass.getClassProject(projectName).getMapping("rdb");
            RdbClassMapping rdbCM = (RdbClassMapping)mapping.getClassMapping();
            RdbFilter mapFilter = rdbCM.getRdbFilter();
            Expression localFilter = null;
            if (mapFilter != null) {
                localFilter = mapFilter.getExpression();
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Mapping filter is " + ExpressionPrinter.e2str(localFilter)));
                }
            }
            if (localFilter == null) {
                if (mapping.isFilteredMapping()) {
                    PClassMapping pcm = extent.getPMapper().lookup(currClass.getFQName());
                    try {
                        localFilter = pcm instanceof NamingFilterKeyProvider ? rdbCM.getMappingFilterFromNamingFilter((NamingFilterKeyProvider)((Object)pcm)) : rdbCM.getMappingFilterFromNamingFilter();
                    }
                    catch (ExpressionException e) {
                        throw new MedorException(e);
                    }
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Naming filter is " + ExpressionPrinter.e2str(localFilter)));
                    }
                }
                if (localFilter == null) {
                    return null;
                }
            }
            localFilter = this.modifiesJormFilterForExtent(localFilter, extent);
            filter = filter == null ? localFilter : new Or(filter, localFilter);
        }
        if (withSubClass) {
            Iterator subclassesIt = currClass.getSubClasses().iterator();
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Subclasses for " + currClass.getName()));
            }
            while (subclassesIt.hasNext()) {
                Class subcl = (Class)subclassesIt.next();
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Recursing for subclass " + subcl.getName() + " of class " + currClass.getName()));
                }
                filter = this.filterForExtent(extent, subcl, projectName, filter, true);
            }
        }
        return filter;
    }

    private Expression modifiesJormFilterForExtent(Expression filter, ClassExtent extent) throws MedorException {
        if (filter instanceof Operator) {
            Operator op = (Operator)filter;
            int opnum = op.getOperandNumber();
            for (int i = 0; i < opnum; ++i) {
                op.setExpression(i, this.modifiesJormFilterForExtent(op.getExpression(i), extent));
            }
            return op;
        }
        if (filter instanceof ParameterOperand) {
            Field f;
            block7: {
                String fieldName = ((ParameterOperand)filter).getName();
                f = null;
                try {
                    f = extent.getField(extent.getJormName() + "." + fieldName);
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Field already on extent: " + fieldName));
                    }
                }
                catch (MedorException me) {
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Catched exception: " + me + " (field not on extent, will be added)"));
                    }
                    f = extent.addField(((Class)extent.getMetaObject()).getTypedElement(fieldName));
                    if (!this.debug) break block7;
                    this.log.log(BasicLevel.DEBUG, (Object)("Added field to extent: " + fieldName + " " + f));
                }
            }
            return new BasicFieldOperand(f);
        }
        return filter;
    }
}

