/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdlScopeBase
extends IdlDefnImplBase {
    private List<Object> defns = new Vector<Object>();
    private Stack<Object> hold = new Stack();
    private List<Object> park = new Vector<Object>();

    protected IdlScopeBase(IdlScopeBase parent, String name) {
        super(parent, name);
    }

    public IdlDefn addToScope(IdlDefn def) {
        String nm = def.localName();
        IdlDefn result = this.lookup(nm);
        if (result == null) {
            this.defns.add(def);
            result = def;
        }
        return result;
    }

    public IdlDefn holdForScope(IdlDefn def) {
        this.hold.push(def);
        return def;
    }

    public IdlDefn promoteHeldToScope() {
        IdlDefn result = (IdlDefn)this.hold.pop();
        this.defns.add(result);
        return result;
    }

    public IdlDefn parkHeld() {
        IdlDefn result = (IdlDefn)this.hold.pop();
        this.park.add(result);
        return result;
    }

    public IdlDefn lookup(String nm) {
        return this.lookup(nm, false);
    }

    public IdlDefn lookup(String nm, boolean undefined) {
        IdlDefn result = null;
        for (IdlDefn idlDefn : this.park) {
            if (!idlDefn.localName().equals(nm)) continue;
            result = idlDefn;
            break;
        }
        if (result == null) {
            for (IdlDefn idlDefn : this.hold) {
                if (!idlDefn.localName().equals(nm)) continue;
                result = idlDefn;
                break;
            }
        }
        if (undefined) {
            return result;
        }
        for (IdlDefn idlDefn : this.defns) {
            if (!idlDefn.localName().equals(nm)) continue;
            result = idlDefn;
            break;
        }
        return result;
    }

    public IdlDefn lookup(IdlScopedName name) {
        return this.lookup(name, false);
    }

    public IdlDefn lookup(IdlScopedName name, boolean undefined) {
        IdlScopeBase scope = this;
        String[] parents = name.parentNames();
        if (parents != null) {
            IdlDefn defn = this.lookup(parents, undefined);
            if (!(defn instanceof IdlScopeBase)) {
                return null;
            }
            scope = (IdlScopeBase)defn;
        }
        return scope.lookup(name.localName(), undefined);
    }

    public IdlDefn lookup(String[] scopedName) {
        return this.lookup(scopedName, false);
    }

    public IdlDefn lookup(String[] scopedName, boolean undefined) {
        IdlScopeBase parent;
        IdlScopeBase scope = this;
        while ((parent = scope.definedIn()) != null) {
            scope = parent;
        }
        IdlDefn result = null;
        for (int i = 0; i < scopedName.length; ++i) {
            boolean inParentScope = scopedName.length > 1 && i < scopedName.length - 1;
            result = scope.lookup(scopedName[i], undefined && !inParentScope);
            if (result == null) {
                return null;
            }
            if (i == scopedName.length - 1) continue;
            if (result instanceof IdlScopeBase) {
                scope = (IdlScopeBase)result;
                continue;
            }
            return null;
        }
        return result;
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        if (doneDefn.contains(this)) {
            return this == startScope ? this : null;
        }
        doneDefn.add(this);
        for (IdlDefn defn : this.definitions()) {
            IdlScopeBase circularScope = defn.getCircularScope(startScope, doneDefn);
            if (circularScope == null) continue;
            return circularScope;
        }
        doneDefn.remove(this);
        return null;
    }

    @Override
    public void write(PrintWriter pw) {
        for (IdlDefn idlDefn : this.defns) {
            idlDefn.write(pw);
        }
    }

    @Override
    public void writeFwd(PrintWriter pw) {
        ListIterator<Object> it = this.defns.listIterator(this.defns.size());
        while (it.hasPrevious()) {
            IdlDefn defn = (IdlDefn)it.previous();
            defn.writeFwd(pw);
        }
    }

    @Override
    public void flush() {
        this.promoteParkedToScope();
        for (IdlDefn defn : this.definitions()) {
            defn.flush();
        }
    }

    protected Collection definitions() {
        return this.defns;
    }

    private void promoteParkedToScope() {
        for (IdlDefn idlDefn : this.park) {
            this.defns.add(idlDefn);
        }
        this.park.clear();
    }
}

