/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.car.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.car.impl.xml.parsing.CAREntityResolver;
import org.ow2.util.ee.metadata.car.impl.xml.struct.CAR;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public final class CARDeploymentDescLoader
extends CommonDeploymentDescLoader {
    private static Log logger = LogFactory.getLog(CARDeploymentDescLoader.class);
    private CAR car = new CAR();

    private CARDeploymentDescLoader(URL url) {
        super(url);
    }

    public static CAR loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        CARDeploymentDescLoader carDeploymentDescLoader = new CARDeploymentDescLoader(url);
        carDeploymentDescLoader.parse();
        return carDeploymentDescLoader.getCAR();
    }

    public void parse() throws ParsingException {
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)this.getURL(), (boolean)CARDeploymentDescLoader.isValidating(), (EntityResolver)((Object)new CAREntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", (Throwable)e);
        }
        Element applicationClientRootElement = document.getDocumentElement();
        if (applicationClientRootElement.getNamespaceURI() != null) {
            this.defineXMLNS(applicationClientRootElement);
        }
        this.analyzeEnvironment(applicationClientRootElement, (IEnvironment)this.car);
        this.car.setCallbackHandler(XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationClientRootElement, (String)"callback-handler"));
        if ("true".equals(applicationClientRootElement.getAttribute("metadata-complete"))) {
            this.car.setMetadataComplete(true);
        } else {
            this.car.setMetadataComplete(false);
        }
    }

    public CAR getCAR() {
        return this.car;
    }
}

