/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpOperations
implements RemoteFileOperations<ChannelSftp.LsEntry> {
    private static final transient Log LOG = LogFactory.getLog(SftpOperations.class);
    private RemoteFileEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public void setEndpoint(GenericFileEndpoint endpoint) {
        this.endpoint = (RemoteFileEndpoint)endpoint;
    }

    @Override
    public boolean connect(RemoteFileConfiguration configuration) throws GenericFileOperationFailedException {
        if (this.isConnected()) {
            return true;
        }
        boolean connected = false;
        int attempt = 0;
        while (!connected) {
            try {
                if (LOG.isTraceEnabled() && attempt > 0) {
                    LOG.trace((Object)("Reconnect attempt #" + attempt + " connecting to + " + configuration.remoteServerInformation()));
                }
                if (this.channel == null || !this.channel.isConnected()) {
                    if (this.session == null || !this.session.isConnected()) {
                        LOG.trace((Object)"Session isn't connected, trying to recreate and connect.");
                        this.session = this.createSession(configuration);
                        if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                            LOG.trace((Object)("Connecting use connectTimeout: " + this.endpoint.getConfiguration().getConnectTimeout() + " ..."));
                            this.session.connect(this.endpoint.getConfiguration().getConnectTimeout());
                        } else {
                            LOG.trace((Object)"Connecting ...");
                            this.session.connect();
                        }
                    }
                    LOG.trace((Object)"Channel isn't connected, trying to recreate and connect.");
                    this.channel = (ChannelSftp)this.session.openChannel("sftp");
                    if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                        LOG.trace((Object)("Connecting use connectTimeout: " + this.endpoint.getConfiguration().getConnectTimeout() + " ..."));
                        this.channel.connect(this.endpoint.getConfiguration().getConnectTimeout());
                    } else {
                        LOG.trace((Object)"Connecting ...");
                        this.channel.connect();
                    }
                    LOG.info((Object)("Connected to " + configuration.remoteServerInformation()));
                }
                connected = true;
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new GenericFileOperationFailedException("Interrupted during connecting", (Throwable)new InterruptedException("Interrupted during connecting"));
                }
                GenericFileOperationFailedException failed = new GenericFileOperationFailedException("Cannot connect to " + configuration.remoteServerInformation(), (Throwable)e);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Cannot connect due: " + failed.getMessage()));
                }
                if (++attempt > this.endpoint.getMaximumReconnectAttempts()) {
                    throw failed;
                }
                if (this.endpoint.getReconnectDelay() <= 0L) continue;
                try {
                    Thread.sleep(this.endpoint.getReconnectDelay());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new GenericFileOperationFailedException("Interrupted during sleeping", (Throwable)ie);
                }
            }
        }
        return true;
    }

    protected Session createSession(final RemoteFileConfiguration configuration) throws JSchException {
        JSch jsch = new JSch();
        JSch.setLogger((Logger)new JSchLogger());
        SftpConfiguration sftpConfig = (SftpConfiguration)configuration;
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFile())) {
            LOG.debug((Object)("Using private keyfile: " + sftpConfig.getPrivateKeyFile()));
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFilePassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile(), sftpConfig.getPrivateKeyFilePassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsFile())) {
            LOG.debug((Object)("Using knownhosts file: " + sftpConfig.getKnownHostsFile()));
            jsch.setKnownHosts(sftpConfig.getKnownHostsFile());
        }
        Session session = jsch.getSession(configuration.getUsername(), configuration.getHost(), configuration.getPort());
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getStrictHostKeyChecking())) {
            LOG.debug((Object)("Using StrickHostKeyChecking: " + sftpConfig.getStrictHostKeyChecking()));
            session.setConfig("StrictHostKeyChecking", sftpConfig.getStrictHostKeyChecking());
        }
        session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return configuration.getPassword();
            }

            public boolean promptPassword(String s) {
                return true;
            }

            public boolean promptPassphrase(String s) {
                return true;
            }

            public boolean promptYesNo(String s) {
                LOG.warn((Object)("Server asks for confirmation (yes|no): " + s + ". Camel will answer no."));
                return false;
            }

            public void showMessage(String s) {
                LOG.trace((Object)("Message received from Server: " + s));
            }
        });
        return session;
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected() && this.channel != null && this.channel.isConnected();
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting file: " + name));
        }
        try {
            this.channel.rm(name);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot delete file: " + name, (Throwable)e);
        }
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming file: " + from + " to: " + to));
        }
        try {
            this.channel.rename(from, to);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
        }
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("buildDirectory(" + directory + "," + absolute + ")"));
        }
        boolean success = false;
        String originalDirectory = this.getCurrentDirectory();
        try {
            try {
                this.channel.cd(directory);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
            if (!success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to build remote directory: " + directory));
                }
                try {
                    this.channel.mkdir(directory);
                    success = true;
                }
                catch (SftpException e) {
                    success = this.buildDirectoryChunks(directory);
                }
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        finally {
            if (originalDirectory != null) {
                this.changeCurrentDirectory(originalDirectory);
            }
        }
        return success;
    }

    private boolean buildDirectoryChunks(String dirName) throws IOException, SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        for (String dir : dirs) {
            sb.append(dir).append('/');
            String directory = sb.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Trying to build remote directory by chunk: " + directory));
            }
            if (directory.equals("/")) continue;
            try {
                this.channel.mkdir(directory);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
        }
        return success;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"getCurrentDirectory()");
        }
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot get current directory", (Throwable)e);
        }
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        String[] dirs;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("changeCurrentDirectory(" + path + ")"));
        }
        if (ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        if (FileUtil.hasLeadingSeparator((String)path)) {
            this.doChangeDirectory(path.substring(0, 1));
            path = path.substring(1);
        }
        if ((dirs = path.split("/|\\\\")) == null || dirs.length == 0) {
            this.doChangeDirectory(path);
            return;
        }
        for (String dir : dirs) {
            this.doChangeDirectory(dir);
        }
    }

    private void doChangeDirectory(String path) {
        if (path == null || ".".equals(path) || ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Changing directory: " + path));
        }
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot change directory to: " + path, (Throwable)e);
        }
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        String current;
        String parent;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"changeToParentDirectory()");
        }
        if (!(parent = FileUtil.compactPath((String)((current = this.getCurrentDirectory()) + "/.."))).startsWith("/")) {
            parent = "/" + parent;
        }
        this.changeCurrentDirectory(parent);
    }

    public List<ChannelSftp.LsEntry> listFiles() throws GenericFileOperationFailedException {
        return this.listFiles(".");
    }

    public List<ChannelSftp.LsEntry> listFiles(String path) throws GenericFileOperationFailedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("listFiles(" + path + ")"));
        }
        if (ObjectHelper.isEmpty((Object)path)) {
            path = ".";
        }
        try {
            ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
            Vector files = this.channel.ls(path);
            if (files != null) {
                for (Object file : files) {
                    list.add((ChannelSftp.LsEntry)file);
                }
            }
            return list;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot list directory: " + path, (Throwable)e);
        }
    }

    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("retrieveFile(" + name + ")"));
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    private boolean retrieveFileToStreamInBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
            target.setBody((Object)os);
            String currentDir = this.getCurrentDirectory();
            String path = FileUtil.onlyPath((String)name);
            if (path != null) {
                this.changeCurrentDirectory(path);
            }
            String onlyName = FileUtil.stripPath((String)name);
            InputStream is = this.channel.get(onlyName);
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
            this.changeCurrentDirectory(currentDir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
        }
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange) throws GenericFileOperationFailedException {
        FileOutputStream os;
        File temp;
        File local = new File(this.endpoint.getLocalWorkDirectory());
        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        ObjectHelper.notNull((Object)file, (String)"Exchange should have the CamelFileExchangeFile set");
        try {
            String relativeName = file.getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !FileUtil.deleteFile((File)temp)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !FileUtil.deleteFile((File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local);
        }
        try {
            file.setBody((Object)local);
            String currentDir = this.getCurrentDirectory();
            String path = FileUtil.onlyPath((String)name);
            if (path != null) {
                this.changeCurrentDirectory(path);
            }
            String onlyName = FileUtil.stripPath((String)name);
            this.channel.get(onlyName, (OutputStream)os);
            this.changeCurrentDirectory(currentDir);
        }
        catch (SftpException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Error occurred during retrieving file: " + name + " to local directory. Deleting local work file: " + temp));
            }
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
            boolean deleted = FileUtil.deleteFile((File)temp);
            if (!deleted) {
                LOG.warn((Object)("Error occurred during retrieving file: " + name + " to local directory. Cannot delete local work file: " + temp));
            }
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Retrieve file to local work file result: true");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Renaming local in progress file from: " + temp + " to: " + local));
        }
        if (!FileUtil.renameFile((File)temp, (File)local)) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
        }
        return true;
    }

    public boolean storeFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("storeFile(" + name + ")"));
        }
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail) {
            boolean existFile = this.existsFile(name);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An existing file already exists: " + name + ". Ignore and do not override it."));
                }
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
        }
        InputStream is = null;
        try {
            is = (InputStream)ExchangeHelper.getMandatoryInBody((Exchange)exchange, InputStream.class);
            if (this.endpoint.getFileExist() == GenericFileExist.Append) {
                this.channel.put(is, name, 2);
            } else {
                this.channel.put(is, name);
            }
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)("store: " + name), (Log)LOG);
        }
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        String directory;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("existsFile(" + name + ")"));
        }
        if ((directory = FileUtil.onlyPath((String)name)) == null) {
            directory = "";
        }
        String onlyName = FileUtil.stripPath((String)name);
        try {
            Vector files = this.channel.ls(directory);
            if (files == null) {
                return false;
            }
            for (Object file : files) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)file;
                if (!entry.getFilename().equals(onlyName)) continue;
                return true;
            }
            return false;
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean sendNoop() throws GenericFileOperationFailedException {
        return true;
    }

    @Override
    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    private static final class JSchLogger
    implements Logger {
        private JSchLogger() {
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return LOG.isFatalEnabled();
                }
                case 3: {
                    return LOG.isErrorEnabled();
                }
                case 2: {
                    return LOG.isWarnEnabled();
                }
                case 1: {
                    return LOG.isInfoEnabled();
                }
            }
            return LOG.isDebugEnabled();
        }

        public void log(int level, String message) {
            switch (level) {
                case 4: {
                    LOG.fatal((Object)("JSCH -> " + message));
                    break;
                }
                case 3: {
                    LOG.error((Object)("JSCH -> " + message));
                    break;
                }
                case 2: {
                    LOG.warn((Object)("JSCH -> " + message));
                    break;
                }
                case 1: {
                    LOG.info((Object)("JSCH -> " + message));
                    break;
                }
                default: {
                    LOG.debug((Object)("JSCH -> " + message));
                }
            }
        }
    }
}

