/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean appContextProtection = true;
    private boolean gcDaemonProtection = true;
    private boolean keepAliveProtection = true;
    private boolean securityPolicyProtection = true;
    private boolean tokenPollerProtection = true;
    private boolean urlCacheProtection = true;
    private boolean xmlParsingProtection = true;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean appContextProtection) {
        this.appContextProtection = appContextProtection;
    }

    public boolean isGcDaemonProtection() {
        return this.gcDaemonProtection;
    }

    public void setGcDaemonProtection(boolean gcDaemonProtection) {
        this.gcDaemonProtection = gcDaemonProtection;
    }

    public boolean isKeepAliveProtection() {
        return this.keepAliveProtection;
    }

    public void setKeepAliveProtection(boolean keepAliveProtection) {
        this.keepAliveProtection = keepAliveProtection;
    }

    public boolean isSecurityPolicyProtection() {
        return this.securityPolicyProtection;
    }

    public void setSecurityPolicyProtection(boolean securityPolicyProtection) {
        this.securityPolicyProtection = securityPolicyProtection;
    }

    public boolean isTokenPollerProtection() {
        return this.tokenPollerProtection;
    }

    public void setTokenPollerProtection(boolean tokenPollerProtection) {
        this.tokenPollerProtection = tokenPollerProtection;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean urlCacheProtection) {
        this.urlCacheProtection = urlCacheProtection;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean xmlParsingProtection) {
        this.xmlParsingProtection = xmlParsingProtection;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            Method method;
            if (this.appContextProtection) {
                ImageIO.getCacheDirectory();
            }
            if (this.gcDaemonProtection) {
                try {
                    Class<?> clazz = Class.forName("sun.misc.GC");
                    method = clazz.getDeclaredMethod("requestLatency", Long.TYPE);
                    method.invoke(null, 3600000L);
                }
                catch (ClassNotFoundException e) {
                    if (System.getProperty("java.vendor").startsWith("Sun")) {
                        log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                    } else {
                        log.debug(sm.getString("jreLeakListener.gcDaemonFail"), e);
                    }
                }
                catch (SecurityException e) {
                    log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                }
                catch (NoSuchMethodException e) {
                    log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                }
                catch (IllegalArgumentException e) {
                    log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                }
                catch (IllegalAccessException e) {
                    log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                }
                catch (InvocationTargetException e) {
                    log.error(sm.getString("jreLeakListener.gcDaemonFail"), e);
                }
            }
            if (this.keepAliveProtection) {
                try {
                    Class.forName("sun.net.www.http.HttpClient");
                }
                catch (ClassNotFoundException e) {
                    if (System.getProperty("java.vendor").startsWith("Sun")) {
                        log.error(sm.getString("jreLeakListener.keepAliveFail"), e);
                    }
                    log.debug(sm.getString("jreLeakListener.keepAliveFail"), e);
                }
            }
            if (this.securityPolicyProtection) {
                try {
                    Class<?> policyClass = Class.forName("javax.security.auth.Policy");
                    method = policyClass.getMethod("getPolicy", new Class[0]);
                    method.invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException e) {
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    log.warn(sm.getString("jreLeakListener.authPolicyFail"), e);
                }
                catch (IllegalArgumentException e) {
                    log.warn(sm.getString("jreLeakListener.authPolicyFail"), e);
                }
                catch (IllegalAccessException e) {
                    log.warn(sm.getString("jreLeakListener.authPolicyFail"), e);
                }
                catch (InvocationTargetException e) {
                    log.warn(sm.getString("jreLeakListener.authPolicyFail"), e);
                }
            }
            if (this.tokenPollerProtection) {
                Security.getProviders();
            }
            if (this.urlCacheProtection) {
                try {
                    URL url = new URL("jar:file://dummy.jar!/");
                    URLConnection uConn = url.openConnection();
                    uConn.setDefaultUseCaches(false);
                }
                catch (MalformedURLException e) {
                    log.error(sm.getString("jreLeakListener.jarUrlConnCacheFail"), e);
                }
                catch (IOException e) {
                    log.error(sm.getString("jreLeakListener.jarUrlConnCacheFail"), e);
                }
            }
            if (this.xmlParsingProtection) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    log.error(sm.getString("jreLeakListener.xmlParseFail"), e);
                }
            }
        }
    }
}

