/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Locale;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static final Log log = LogFactory.getLog(StandardEngine.class);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String jvmRouteId;
    private volatile AccessLog defaultAccessLog;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase(Locale.ENGLISH);
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    @Override
    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info("Starting Servlet Engine: " + ServerInfo.getServerInfo());
        }
        super.startInternal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void logAccess(Request request, Response response, long time, boolean useDefault) {
        boolean logged = false;
        if (this.accessLog != null) {
            this.accessLog.log(request, response, time);
            logged = true;
        }
        if (!logged && useDefault) {
            Host host = null;
            if (this.defaultAccessLog == null) {
                host = (Host)this.findChild(this.getDefaultHost());
                this.defaultAccessLog = host.getAccessLog();
                if (this.defaultAccessLog == null) {
                    Context context = (Context)host.findChild("");
                    if (context != null) {
                        this.defaultAccessLog = context.getAccessLog();
                    }
                    if (this.defaultAccessLog == null) {
                        this.defaultAccessLog = new ContainerBase.NoopAccessLog();
                    }
                }
            }
            this.defaultAccessLog.log(request, response, time);
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.service != null) {
            return this.service.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Engine";
    }
}

