/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.versioning;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.ow2.jonas.web.tomcat7.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat7.versioning.VersionedPathBean;

public class VersioningValve
extends ValveBase {
    private static final ThreadLocal<VersionedPathBean> THREAD_VPB = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        VersionedPathBean vpb = THREAD_VPB.get();
        try {
            if (vpb == null) {
                try {
                    vpb = new VersionedPathBean();
                    vpb.setOriginalDecodedUri(request.getDecodedRequestURI());
                    THREAD_VPB.set(vpb);
                    response.setVersionedPathBean(vpb);
                    CoyoteAdapter adapter = (CoyoteAdapter)request.getConnector().getProtocolHandler().getAdapter();
                    String requestURI = request.getRequestURI();
                    String versionedURI = ContextFinder.getContextURI(requestURI, request, vpb);
                    if (!versionedURI.equals(requestURI)) {
                        String encoding = request.getConnector().getURIEncoding();
                        if (encoding == null) {
                            encoding = "ISO-8859-1";
                        }
                        request.getMappingData().recycle();
                        request.getCoyoteRequest().requestURI().setChars(versionedURI.toCharArray(), 0, versionedURI.length());
                        byte[] versionedURIBytes = versionedURI.getBytes(encoding);
                        request.getCoyoteRequest().requestURI().setBytes(versionedURIBytes, 0, versionedURIBytes.length);
                        try {
                            adapter.service(request.getCoyoteRequest(), response.getCoyoteResponse());
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    } else {
                        this.getNext().invoke(request, response);
                    }
                    Object var11_10 = null;
                    THREAD_VPB.remove();
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    THREAD_VPB.remove();
                    throw throwable;
                }
            } else {
                response.setVersionedPathBean(vpb);
                this.getNext().invoke(request, response);
            }
            Object var13_13 = null;
            response.setVersionedPathBean(null);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            response.setVersionedPathBean(null);
            throw throwable;
        }
    }
}

